% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{makeRule}
\alias{makeRule}
\title{Transforms a single BNF rule into a production table.}
\usage{
makeRule(Rule, ST)
}
\arguments{
\item{Rule}{A rule.}

\item{ST}{A symbol table.}
}
\value{
A named list with 2 elements, namely \code{$LHS} and \code{$RHS}. 
        The left-hand side \code{$LHS} is 
        a vector of non-terminal identifiers
        and the right-hand side \code{$RHS} is a vector of vectors
        of numerical identifiers. 
        The list represents the substitution of \code{$LHS[i]} 
        by the identifier list \code{$RHS[[i]]}.
}
\description{
\code{makeRule()} transforms a single BNF rule
             into a production table.
}
\details{
Because a single BNF rule can provide a set of substitutions, 
         more than one line in a production table may result.
         The number of substitutions corresponds to the number of lines 
         in the production table.
}
\examples{
c<-booleanGrammar()$BNF
ST<-makeSymbolTable(c)
c<-booleanGrammar()$BNF 
b<-strsplit(c,";")[[1]]
a<-b[2:4]
a<-gsub(pattern=";",replacement="", paste(a[1], a[2], a[3], sep=""))
makeRule(a, ST)

}
