% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{symb2id}
\alias{symb2id}
\title{Convert a symbol to a numeric identifier.}
\usage{
symb2id(sym, ST)
}
\arguments{
\item{sym}{A character string with the symbol, e.g. <fe> or "NOT".}

\item{ST}{A symbol table.}
}
\value{
\itemize{
        \item A positive integer if the symbol exists or  
        \item an empty integer (\code{integer(0)}) 
              if the symbol does not exist.}
}
\description{
\code{symb2id()} converts a symbol to a numeric id.
}
\examples{
g<-compileBNF(booleanGrammar())
symb2id("<fe>", g$ST)
symb2id("NOT", g$ST)
symb2id("<fe", g$ST)
symb2id("NO", g$ST)
identical(symb2id("NO", g$ST), integer(0))

}
\seealso{
Other Utility Functions: 
\code{\link{derive}()},
\code{\link{id2symb}()},
\code{\link{isNonTerminal}()},
\code{\link{isTerminal}()},
\code{\link{rules}()}
}
\concept{Utility Functions}
