% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfCrossover.R
\name{xegaDfUPCrossGene}
\alias{xegaDfUPCrossGene}
\title{Parameterized uniform crossover of 2 genes.}
\usage{
xegaDfUPCrossGene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{Real-coded gene.}

\item{gg2}{Real-coded gene.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
Real-coded gene.
}
\description{
\code{UPCrossGene} swaps alleles of both genes
             with a probability of \code{lF$UCrossSwap}. 
             It generate a random 
             mask which is used to build the new gene.
}
\examples{
gene1<-xegaDfInitGene(lFxegaDfGene)
gene2<-xegaDfInitGene(lFxegaDfGene)
gene3<-xegaDfUPCrossGene(gene1, gene2, lFxegaDfGene)
}
\references{
Spears William and De Jong, Kenneth (1991):
  On the Virtues of Parametrized Uniform Crossover. 
  In: Belew, Richard K. and Booker, Lashon B. (Ed.)
  Proceedings of the Fourth International Conference on Genetic Algorithms,
  Morgan Kaufmann Publishers, Los Altos, California, pp. 230-236.
  (ISBN: 1-55860-208-9)

Price, Kenneth V., Storn, Rainer M. and Lampinen, Jouni A. (2005)
The Differential Evolution Algorithm (Chapter 2), pp. 37-134.
In: Differential Evolution. A Practical Approach to Global Optimization.
Springer, Berlin.
<doi:10.1007/3-540-31306-0>
}
\seealso{
Other Crossover (1): 
\code{\link{xegaDfCrossGene}()},
\code{\link{xegaDfUCrossGene}()}
}
\concept{Crossover (1)}
