% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.save.raw.R
\name{xgb.save.raw}
\alias{xgb.save.raw}
\title{Save xgboost model to R's raw vector,
user can call xgb.load.raw to load the model back from raw vector}
\usage{
xgb.save.raw(model, raw_format = "deprecated")
}
\arguments{
\item{model}{the model object.}

\item{raw_format}{The format for encoding the booster.  Available options are
\itemize{
    \item \code{json}: Encode the booster into JSON text document.
    \item \code{ubj}:  Encode the booster into Universal Binary JSON.
    \item \code{deprecated}: Encode the booster into old customized binary format.
}

Right now the default is \code{deprecated} but will be changed to \code{ubj} in upcoming release.}
}
\description{
Save xgboost model from xgboost or xgb.train
}
\examples{
data(agaricus.train, package='xgboost')
data(agaricus.test, package='xgboost')

## Keep the number of threads to 2 for examples
nthread <- 2
data.table::setDTthreads(nthread)

train <- agaricus.train
test <- agaricus.test
bst <- xgboost(data = train$data, label = train$label, max_depth = 2,
               eta = 1, nthread = nthread, nrounds = 2,objective = "binary:logistic")

raw <- xgb.save.raw(bst)
bst <- xgb.load.raw(raw)

}
