% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgrove.R
\name{plot.xgrove}
\alias{plot.xgrove}
\title{Plot surrogate grove statistics}
\usage{
\method{plot}{xgrove}(x, abs = "rules", ord = "upsilon", ...)
}
\arguments{
\item{x}{An object of class \code{xgrove}.}

\item{abs}{Name of the measure to be plotted on the x-axis, either \code{"trees"}, \code{"rules"}, \code{"upsilon"} or \code{"cor"}.}

\item{ord}{Name of the measure to be plotted on the y-axis, either \code{"trees"}, \code{"rules"}, \code{"upsilon"} or \code{"cor"}.}

\item{...}{Further arguments passed to \code{plot}.}
}
\value{
No return value.
}
\description{
Plot statistics of surrogate groves to analyze complexity vs. explanatory power.
}
\examples{
library(randomForest)
library(pdp)
data(boston)
set.seed(42)
rf <- randomForest(cmedv ~ ., data = boston)
data <- boston[,-3] # remove target variable
ntrees <- c(4,8,16,32,64,128)
xg <- xgrove(rf, data, ntrees)
xg
plot(xg)

}
\author{
\email{gero.szepannek@web.de}
}
