% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_stat_smooth.R
\name{predictdf.nls}
\alias{predictdf.nls}
\title{Prediction data frame for nls}
\usage{
\method{predictdf}{nls}(model, xseq, se, level)
}
\arguments{
\item{model}{nls object}

\item{xseq}{newdata}

\item{se}{Display confidence interval around smooth?}

\item{level}{Level of confidence interval to use}
}
\value{
dataframe with x and y values, if se is TRUE dataframe also includes ymin and ymax
}
\description{
Get predictions with standard errors into data frame for use with geom_smooth
}
\details{
\code{ggplot2::geom_smooth} produces confidence intervals by silently calling functions 
of the form predictdf.method, where method is "loess", "lm", "glm" etc. 
depending on what method is specified in the call to \code{geom_smooth}. 
Currently \code{ggplot2} does not define a \code{predictdf.nls} function for method of type "nls", 
and thus confidence intervals cannot be automatically generated by \code{geom_smooth} 
for method = "nls". Here we define \code{predictdf.nls} for calculating the confidence 
intervals of an object of type nls. \code{geom_smooth} will silently call this function 
whenever method = "nls", and produce the appropriate confidence intervals.

\code{predictdf.nls} calculates CI for a model fit of class nls based on the "delta-method" 
http://sia.webpopix.org/nonlinearRegression.html#confidence-intervals-and-prediction-intervals)

CI = [ f(x0, beta) + qt_(alpha/2, n - d) * se(f(x0, beta)),
      f(x0, beta) + qt_(1 - alpha/2, n - d) * se(f(x0, beta))]

where:
beta = vector of parameter estimates
x = independent variable
se(f(x0, beta)) = sqrt( delta(f)(x0, beta) * Var(beta) * (delta(f)(x0, beta))' )
delta(f) is the gradient of f
}
