% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.nls.R
\name{predict.nls}
\alias{predict.nls}
\title{predict.nls}
\usage{
\method{predict}{nls}(
  object,
  newdata = NULL,
  se.fit = FALSE,
  interval = "none",
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{Object of class inheriting from "nls"}

\item{newdata}{An optional data frame in which to look for variables with which to predict. 
If omitted, the fitted values are used.}

\item{se.fit}{A switch indicating if standard errors are required.}

\item{interval}{Type of interval calculation, "none" or "confidence"}

\item{level}{Level of confidence interval to use}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
\code{predict.nls} produces a vector of predictions or a matrix of predictions and 
bounds with column names \code{fit}, \code{lwr}, and \code{upr} if interval is set. 

If \code{se.fit} is \code{TRUE}, a list with the following components is returned:

\item{fit}{vector or matrix as above}

\item{se.fit}{standard error of predicted means}

\item{residual.scale}{residual standard deviations}

\item{df}{degrees of freedom for residual}
}
\description{
predict.nls
}
\examples{

set.seed(12345)
data_to_plot <- data.frame(x1 = rep(c(0, 25, 50, 100, 200, 400, 600), 10)) \%>\%
  dplyr::mutate(AUC = x1*rlnorm(length(x1), 0, 0.3),
         x2 = x1*stats::rlnorm(length(x1), 0, 0.3),
         Response = (15 + 50*x2/(20+x2))*stats::rlnorm(length(x2), 0, 0.3))


gg <- ggplot2::ggplot(data = data_to_plot, ggplot2::aes(x = AUC, y = Response)) + 
  ggplot2::geom_point() + 
  xgx_geom_smooth(method = "nls",  
                  method.args = list(formula = y ~ E0 + Emax* x / (EC50 + x),
                                     start = list(E0 = 15, Emax = 50, EC50 = 20) ), 
                  color = "black", size = 0.5, alpha = 0.25)
gg

mod <- stats::nls(formula = Response ~ E0 + Emax * AUC / (EC50 + AUC), 
data = data_to_plot, 
start = list(E0 = 15, Emax = 50, EC50 = 20))

predict.nls(mod)

predict.nls(mod, se.fit = TRUE)

predict.nls(mod, 
            newdata = data.frame(AUC = c(0, 25, 50, 100, 200, 400, 600)), 
            se.fit = TRUE)
            
predict.nls(mod, 
            newdata = data.frame(AUC = c(0, 25, 50, 100, 200, 400, 600)), 
            se.fit = TRUE, interval = "confidence", level = 0.95)
            
predict(mod, 
            newdata = data.frame(AUC = c(0, 25, 50, 100, 200, 400, 600)), 
            se.fit = TRUE, interval = "confidence", level = 0.95)

}
