#' @title HSLEffect
#'
#' @description \url{https://openpyxl.readthedocs.io/en/stable/api/openpyxl.drawing.effect.html}
#'
#' @param hue hue
#' @param sat sat
#' @param lum lum
#' @param ... Additional arguments, i.e. kwargs.
#'
#' @return An openpyxl Python object.
#'
#' @examples
#' \dontrun{
#' HSLEffect(hue = 1L, sat = 1L, lum = 1L)
#' }
#'
#' @export
HSLEffect <- function(hue = NULL, sat = NULL, lum = NULL, ...) {

  py_obj <- openpyxl$drawing$effect$HSLEffect(
    hue = hue,
    sat = sat,
    lum = lum
  )

  # as of openpyxl docs, additional arguments ('**kw')
  kwargs <- list(...)
  for(i in seq_along(kwargs)) {
    name <- names(kwargs)[i]
    py_obj[[name]] <- kwargs[[i]]
  }

  return(py_obj)
}
