% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergedCellRange.R
\name{MergedCellRange}
\alias{MergedCellRange}
\title{MergedCellRange}
\usage{
MergedCellRange(worksheet, coord, ...)
}
\arguments{
\item{worksheet}{worksheet}

\item{coord}{coord}

\item{...}{Additional arguments, i.e. kwargs.}
}
\value{
An openpyxl Python object.
}
\description{
MergedCellRange stores the border information of a merged cell in the top

\url{https://openpyxl.readthedocs.io/en/stable/api/openpyxl.worksheet.merge.html}
}
\details{
left cell of the merged cell.
The remaining cells in the merged cell are stored as MergedCell objects and
get their border information from the upper left cell.
}
\examples{
\dontrun{
wb <- Workbook()
MergedCellRange(worksheet = wb$active, coord = "A1")
}

}
