% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPayments_Transaction.R
\name{getPayments_Transaction}
\alias{getPayments_Transaction}
\title{Get an overview of payments for a specific transaction.}
\usage{
getPayments_Transaction(hash, cursor = NULL, limit = 10,
  order = "asc", data.table = TRUE, domain = "public")
}
\arguments{
\item{hash}{character = the transaction id.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{domain}{character - signalling to query the testnet or public network. Can be either "testnet" or "public".}
}
\value{
data.table (by default) or list
}
\description{
Returns all payment operations that are part of a given transaction. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/payments-for-tranasction.html
}
\examples{
\donttest{getPayments_Transaction("someHash")}
}
