% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Account.R
\docType{data}
\name{Account}
\alias{Account}
\title{Account object.}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Account
}
\description{
An R6 class representing an Account on the Stellar network.
    It is initialized from the getAccountDetail() function.
}
\section{Fields}{

\describe{
\item{\code{pk}}{- character representing the public key of the account.}

\item{\code{sequence}}{- the current transaction sequence number of the account.}

\item{\code{balances}}{- a list of balances, including the native XLM and any other assets the account holds.}

\item{\code{signers}}{- get information about the signers who authorize activity on the account.}

\item{\code{data}}{- get any data key-value pairs (not secret keys) that have been assigned to the account.}

\item{\code{response}}{- list containing the raw JSON response.}
}}

\note{
https://www.stellar.org/developers/guides/concepts/accounts.html
}
\examples{
binance <- Account$new("GCO2IP3MJNUOKS4PUDI4C7LGGMQDJGXG3COYX3WSB4HHNAHKYV5YL3VC")
binance$effects()
}
\keyword{datasets}
