/*
 * Decompiled with CFR 0.152.
 */
package dev;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class RInterface {
    public int NCOLS = 0;
    public int NROWS = 0;
    public Cell[][] CELL_ARRAY;

    public void createCells(Sheet sheet, int startRowIndex, int startColIndex) {
        this.CELL_ARRAY = new Cell[this.NROWS][this.NCOLS];
        int i = 0;
        while (i < this.NROWS) {
            Row r = sheet.getRow(i + startRowIndex);
            if (r == null) {
                r = sheet.createRow(i + startRowIndex);
            }
            int j = 0;
            while (j < this.NCOLS) {
                this.CELL_ARRAY[i][j] = r.createCell(j + startColIndex);
                ++j;
            }
            ++i;
        }
    }

    public double[] readColDoubles(Sheet sheet, int startRowIndex, int endRowIndex, int colIndex) {
        int N = endRowIndex - startRowIndex + 1;
        double[] res = new double[N];
        int i = 0;
        while (i < N) {
            Row row = sheet.getRow(startRowIndex + i);
            Cell cell = row.getCell(colIndex, Row.CREATE_NULL_AS_BLANK);
            switch (cell.getCellType()) {
                case 1: {
                    try {
                        res[i] = Double.valueOf(cell.getStringCellValue());
                    }
                    catch (NumberFormatException nfe) {
                        res[i] = Double.NaN;
                    }
                    break;
                }
                case 0: {
                    res[i] = cell.getNumericCellValue();
                    break;
                }
                case 2: {
                    try {
                        res[i] = cell.getNumericCellValue();
                    }
                    catch (IllegalStateException e) {
                        res[i] = Double.NaN;
                    }
                    break;
                }
                case 4: {
                    res[i] = cell.getBooleanCellValue() ? 1 : 0;
                    break;
                }
                case 5: {
                    res[i] = Double.NaN;
                    break;
                }
                default: {
                    res[i] = Double.NaN;
                }
            }
            ++i;
        }
        return res;
    }

    public String[] readColStrings(Sheet sheet, int startRowIndex, int endRowIndex, int colIndex) {
        int N = endRowIndex - startRowIndex + 1;
        String[] res = new String[N];
        int i = 0;
        while (i < N) {
            Row row = sheet.getRow(startRowIndex + i);
            Cell cell = row.getCell(colIndex, Row.CREATE_NULL_AS_BLANK);
            switch (cell.getCellType()) {
                case 1: {
                    res[i] = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    res[i] = Double.toString(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    try {
                        res[i] = cell.getStringCellValue();
                    }
                    catch (IllegalStateException e) {
                        res[i] = "NA";
                    }
                    break;
                }
                case 4: {
                    res[i] = new Boolean(cell.getBooleanCellValue()).toString();
                    break;
                }
                case 3: {
                    res[i] = "";
                    break;
                }
                case 5: {
                    res[i] = "ERROR";
                    break;
                }
                default: {
                    res[i] = "";
                }
            }
            ++i;
        }
        return res;
    }

    public String[] readRowStrings(Sheet sheet, int startColIndex, int endColIndex, int rowIndex) {
        int N = endColIndex - startColIndex + 1;
        String[] res = new String[N];
        Row row = sheet.getRow(rowIndex);
        int i = 0;
        while (i < N) {
            Cell cell = row.getCell(startColIndex + i, Row.CREATE_NULL_AS_BLANK);
            switch (cell.getCellType()) {
                case 1: {
                    res[i] = cell.getStringCellValue();
                    break;
                }
                case 0: {
                    res[i] = Double.toString(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    res[i] = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    res[i] = new Boolean(cell.getBooleanCellValue()).toString();
                    break;
                }
                default: {
                    res[i] = "";
                }
            }
            ++i;
        }
        return res;
    }

    public void writeColDoubles(Sheet sheet, int startRowIndex, int startColIndex, double[] data, boolean showNaN, CellStyle cellStyle) {
        int N = data.length;
        int i = 0;
        while (i < N) {
            if (!showNaN || data[i] != Double.NaN) {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellValue(data[i]);
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellStyle(cellStyle);
            }
            ++i;
        }
    }

    public void writeColDoubles(Sheet sheet, int startRowIndex, int startColIndex, double[] data, boolean showNaN) {
        int N = data.length;
        int i = 0;
        while (i < N) {
            if (!showNaN && Double.isNaN(data[i])) {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellType(3);
            } else {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellValue(data[i]);
            }
            ++i;
        }
    }

    public void writeColInts(Sheet sheet, int startRowIndex, int startColIndex, int[] data, boolean showNA) {
        int N = data.length;
        int i = 0;
        while (i < N) {
            if (!showNA && data[i] == Integer.MIN_VALUE) {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellType(3);
            } else {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellValue((double)data[i]);
            }
            ++i;
        }
    }

    public void writeColInts(Sheet sheet, int startRowIndex, int startColIndex, int[] data, boolean showNA, CellStyle cellStyle) {
        int N = data.length;
        int i = 0;
        while (i < N) {
            if (!showNA && data[i] == Integer.MIN_VALUE) {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellType(3);
            } else {
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellValue((double)data[i]);
                this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellStyle(cellStyle);
            }
            ++i;
        }
    }

    public void writeColStrings(Sheet sheet, int startRowIndex, int startColIndex, String[] data) {
        int N = data.length;
        int i = 0;
        while (i < N) {
            this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellValue(data[i]);
            ++i;
        }
    }

    public void writeColStrings(Sheet sheet, int startRowIndex, int startColIndex, String[] data, CellStyle cellStyle) {
        int N = data.length;
        int i = 0;
        while (i < N) {
            this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellValue(data[i]);
            this.CELL_ARRAY[startRowIndex + i][startColIndex].setCellStyle(cellStyle);
            ++i;
        }
    }

    public void writeRowStrings(Sheet sheet, int startRowIndex, int startColIndex, String[] data) {
        int N = data.length;
        int j = 0;
        while (j < N) {
            this.CELL_ARRAY[startRowIndex][startColIndex + j].setCellValue(data[j]);
            ++j;
        }
    }

    public void writeRowStrings(Sheet sheet, int startRowIndex, int startColIndex, String[] data, CellStyle cellStyle) {
        int N = data.length;
        int j = 0;
        while (j < N) {
            this.CELL_ARRAY[startRowIndex][startColIndex + j].setCellValue(data[j]);
            this.CELL_ARRAY[startRowIndex][startColIndex + j].setCellStyle(cellStyle);
            ++j;
        }
    }
}

