% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoRefresh.R
\name{forceFormulaRefresh}
\alias{forceFormulaRefresh}
\alias{forcePivotTableRefresh}
\title{Force Refresh Pivot Tables and Formulae}
\usage{
forceFormulaRefresh(file, output = NULL, verbose = FALSE)

forcePivotTableRefresh(file, output = NULL, verbose = FALSE)
}
\arguments{
\item{file}{the path of the source file where formulae/pivot table needs to be refreshed}

\item{output}{the path of the output file.  If it is \code{NULL} then the source file will be overwritten}

\item{verbose}{Whether to make logging more verbose}
}
\value{
Does not return any results
}
\description{
Functions to force formula calculation or refresh of pivot 
tables when the Excel file is opened.
}
\details{
\code{forcePivotTableRefresh} forces pivot tables to be refreshed when the Excel file is opened.
\code{forceFormulaRefresh} forces formulae to be recalculated when the Excel file is opened.
}
\examples{
# Patch a file where its pivot tables are not recalculated when the file is opened
\dontrun{
forcePivotTableRefresh("/tmp/file.xlsx")
forcePivotTableRefresh("/tmp/file.xlsx", "/tmp/fixed_file.xlsx")
}
# Patch a file where its formulae are not recalculated when the file is opened
\dontrun{
forceFormulaRefresh("/tmp/file.xlsx")
forceFormulaRefresh("/tmp/file.xlsx", "/tmp/fixed_file.xlsx")
}


}
\author{
Tom Kwong
}
