/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.poi.xssf.model.Table;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STXmlDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFExportToXml
implements Comparator<String> {
    private XSSFMap map;

    public XSSFExportToXml(XSSFMap map) {
        this.map = map;
    }

    public void exportToXML(OutputStream os, boolean validate) throws SAXException {
        this.exportToXML(os, "UTF-8", validate);
    }

    private Document getEmptyDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public void exportToXML(OutputStream os, String encoding, boolean validate) throws SAXException {
        List<XSSFSingleXmlCell> singleXMLCells = this.map.getRelatedSingleXMLCell();
        List<Table> tables = this.map.getRelatedTables();
        String rootElement = this.map.getCtMap().getRootElement();
        try {
            Document doc = this.getEmptyDocument();
            Element root = null;
            root = this.isNamespaceDeclared() ? doc.createElementNS(this.getNamespace(), rootElement) : doc.createElement(rootElement);
            doc.appendChild(root);
            Vector<String> xpaths = new Vector<String>();
            HashMap<String, XSSFSingleXmlCell> singleXmlCellsMappings = new HashMap<String, XSSFSingleXmlCell>();
            HashMap<String, Table> tableMappings = new HashMap<String, Table>();
            for (XSSFSingleXmlCell simpleXmlCell : singleXMLCells) {
                xpaths.add(simpleXmlCell.getXpath());
                singleXmlCellsMappings.put(simpleXmlCell.getXpath(), simpleXmlCell);
            }
            for (Table table : tables) {
                String commonXPath = table.getCommonXpath();
                xpaths.add(commonXPath);
                tableMappings.put(commonXPath, table);
            }
            Collections.sort(xpaths, this);
            for (String xpath : xpaths) {
                XSSFCell cell;
                XSSFSingleXmlCell simpleXmlCell = (XSSFSingleXmlCell)singleXmlCellsMappings.get(xpath);
                Table table = (Table)tableMappings.get(xpath);
                if (xpath.matches(".*\\[.*")) continue;
                if (simpleXmlCell != null && (cell = simpleXmlCell.getReferencedCell()) != null) {
                    Node currentNode = this.getNodeByXPath(xpath, doc.getFirstChild(), doc, false);
                    STXmlDataType.Enum dataType = simpleXmlCell.getXmlDataType();
                    this.mapCellOnNode(cell, currentNode, dataType);
                }
                if (table == null) continue;
                List<XSSFXmlColumnPr> tableColumns = table.getXmlColumnPrs();
                XSSFSheet sheet = table.getXSSFSheet();
                int startRow = table.getStartCellReference().getRow();
                int endRow = table.getEndCellReference().getRow();
                for (int i = ++startRow; i <= endRow; ++i) {
                    int startColumnIndex;
                    XSSFRow row = sheet.getRow(i);
                    Node tableRootNode = this.getNodeByXPath(table.getCommonXpath(), doc.getFirstChild(), doc, true);
                    for (int j = startColumnIndex = table.getStartCellReference().getCol(); j <= table.getEndCellReference().getCol(); ++j) {
                        XSSFCell cell2 = row.getCell(j);
                        if (cell2 == null) continue;
                        XSSFXmlColumnPr pointer = tableColumns.get(j - startColumnIndex);
                        String localXPath = pointer.getLocalXPath();
                        Node currentNode = this.getNodeByXPath(localXPath, tableRootNode, doc, false);
                        STXmlDataType.Enum dataType = pointer.getXmlDataType();
                        this.mapCellOnNode(cell2, currentNode, dataType);
                    }
                }
            }
            boolean isValid = true;
            if (validate) {
                isValid = this.isValid(doc);
            }
            if (isValid) {
                TransformerFactory transfac = TransformerFactory.newInstance();
                Transformer trans = transfac.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", "yes");
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("encoding", encoding);
                StreamResult result = new StreamResult(os);
                DOMSource source = new DOMSource(doc);
                trans.transform(source, result);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private boolean isValid(Document xml) throws SAXException {
        boolean isValid = false;
        try {
            String language = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory factory = SchemaFactory.newInstance(language);
            DOMSource source = new DOMSource(this.map.getSchema());
            Schema schema = factory.newSchema(source);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(xml));
            isValid = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isValid;
    }

    private void mapCellOnNode(XSSFCell cell, Node node, STXmlDataType.Enum outputDataType) {
        String value = "";
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 4: {
                value = value + cell.getBooleanCellValue();
                break;
            }
            case 5: {
                value = cell.getErrorCellString();
            }
            case 2: {
                value = cell.getStringCellValue();
                break;
            }
            case 0: {
                value = value + cell.getRawValue();
                break;
            }
        }
        if (node instanceof Element) {
            Element currentElement = (Element)node;
            currentElement.setTextContent(value);
        } else {
            node.setNodeValue(value);
        }
    }

    private String removeNamespace(String elementName) {
        return elementName.matches(".*:.*") ? elementName.split(":")[1] : elementName;
    }

    private Node getNodeByXPath(String xpath, Node rootNode, Document doc, boolean createMultipleInstances) {
        String[] xpathTokens = xpath.split("/");
        Node currentNode = rootNode;
        for (int i = 2; i < xpathTokens.length; ++i) {
            Node attribute;
            String axisName = this.removeNamespace(xpathTokens[i]);
            if (!axisName.startsWith("@")) {
                NodeList list = currentNode.getChildNodes();
                Node selectedNode = null;
                if (!createMultipleInstances || i != xpathTokens.length - 1) {
                    selectedNode = this.selectNode(axisName, list);
                }
                if (selectedNode == null) {
                    selectedNode = this.createElement(doc, currentNode, axisName);
                }
                currentNode = selectedNode;
                continue;
            }
            currentNode = attribute = this.createAttribute(doc, currentNode, axisName);
        }
        return currentNode;
    }

    private Node createAttribute(Document doc, Node currentNode, String axisName) {
        String attributeName = axisName.substring(1);
        NamedNodeMap attributesMap = currentNode.getAttributes();
        Node attribute = attributesMap.getNamedItem(attributeName);
        if (attribute == null) {
            attribute = doc.createAttribute(attributeName);
            attributesMap.setNamedItem(attribute);
        }
        return attribute;
    }

    private Node createElement(Document doc, Node currentNode, String axisName) {
        Element selectedNode = this.isNamespaceDeclared() ? doc.createElementNS(this.getNamespace(), axisName) : doc.createElement(axisName);
        currentNode.appendChild(selectedNode);
        return selectedNode;
    }

    private Node selectNode(String axisName, NodeList list) {
        Node selectedNode = null;
        for (int j = 0; j < list.getLength(); ++j) {
            Node node = list.item(j);
            if (!node.getNodeName().equals(axisName)) continue;
            selectedNode = node;
            break;
        }
        return selectedNode;
    }

    private boolean isNamespaceDeclared() {
        String schemaNamespace = this.getNamespace();
        return schemaNamespace != null && !schemaNamespace.equals("");
    }

    private String getNamespace() {
        return this.map.getCTSchema().getNamespace();
    }

    @Override
    public int compare(String leftXpath, String rightXpath) {
        String[] rightTokens;
        int result = 0;
        Node xmlSchema = this.map.getSchema();
        String[] leftTokens = leftXpath.split("/");
        int minLenght = leftTokens.length < (rightTokens = rightXpath.split("/")).length ? leftTokens.length : rightTokens.length;
        Node localComplexTypeRootNode = xmlSchema;
        for (int i = 1; i < minLenght; ++i) {
            String leftElementName = leftTokens[i];
            String rightElementName = rightTokens[i];
            if (leftElementName.equals(rightElementName)) {
                Node complexType;
                localComplexTypeRootNode = complexType = this.getComplexTypeForElement(leftElementName, xmlSchema, localComplexTypeRootNode);
                continue;
            }
            int leftIndex = this.indexOfElementInComplexType(leftElementName, localComplexTypeRootNode);
            int rightIndex = this.indexOfElementInComplexType(rightElementName, localComplexTypeRootNode);
            if (leftIndex == -1 || rightIndex == -1) continue;
            if (leftIndex < rightIndex) {
                result = -1;
            }
            if (leftIndex <= rightIndex) continue;
            result = 1;
        }
        return result;
    }

    private int indexOfElementInComplexType(String elementName, Node complexType) {
        NodeList list = complexType.getChildNodes();
        int indexOf = -1;
        for (int i = 0; i < list.getLength(); ++i) {
            Node nameAttribute;
            Node node = list.item(i);
            if (!(node instanceof Element) || !node.getLocalName().equals("element") || !(nameAttribute = node.getAttributes().getNamedItem("name")).getNodeValue().equals(this.removeNamespace(elementName))) continue;
            indexOf = i;
            break;
        }
        return indexOf;
    }

    private Node getComplexTypeForElement(String elementName, Node xmlSchema, Node localComplexTypeRootNode) {
        Node complexTypeNode = null;
        String elementNameWithoutNamespace = this.removeNamespace(elementName);
        NodeList list = localComplexTypeRootNode.getChildNodes();
        String complexTypeName = "";
        for (int i = 0; i < list.getLength(); ++i) {
            Node complexTypeAttribute;
            Node nameAttribute;
            Node node = list.item(i);
            if (!(node instanceof Element) || !node.getLocalName().equals("element") || !(nameAttribute = node.getAttributes().getNamedItem("name")).getNodeValue().equals(elementNameWithoutNamespace) || (complexTypeAttribute = node.getAttributes().getNamedItem("type")) == null) continue;
            complexTypeName = complexTypeAttribute.getNodeValue();
            break;
        }
        if (!complexTypeName.equals("")) {
            NodeList complexTypeList = xmlSchema.getChildNodes();
            for (int i = 0; i < complexTypeList.getLength(); ++i) {
                Node nameAttribute;
                Node node = list.item(i);
                if (!(node instanceof Element) || !node.getLocalName().equals("complexType") || !(nameAttribute = node.getAttributes().getNamedItem("name")).getNodeValue().equals(complexTypeName)) continue;
                NodeList complexTypeChildList = node.getChildNodes();
                for (int j = 0; j < complexTypeChildList.getLength(); ++j) {
                    Node sequence = complexTypeChildList.item(j);
                    if (!(sequence instanceof Element) || !sequence.getLocalName().equals("sequence")) continue;
                    complexTypeNode = sequence;
                    break;
                }
                if (complexTypeNode != null) break;
            }
        }
        return complexTypeNode;
    }
}

