/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFEvenFooter;
import org.apache.poi.xssf.usermodel.XSSFEvenHeader;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFFirstFooter;
import org.apache.poi.xssf.usermodel.XSSFFirstHeader;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFOddFooter;
import org.apache.poi.xssf.usermodel.XSSFOddHeader;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import org.apache.poi.xssf.usermodel.helpers.XSSFRowShifter;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMergeCells;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOutlinePr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageBreak;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageMargins;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPageSetUpPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPrintOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSelection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetData;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetViews;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPane;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPaneState;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorksheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFSheet
extends POIXMLDocumentPart
implements Sheet {
    private static final POILogger logger = POILogFactory.getLogger(XSSFSheet.class);
    protected CTSheet sheet;
    protected CTWorksheet worksheet;
    private TreeMap<Integer, XSSFRow> rows;
    private List<XSSFHyperlink> hyperlinks;
    private ColumnHelper columnHelper;
    private CommentsTable sheetComments;
    private Map<Integer, XSSFCell> sharedFormulas;

    protected XSSFSheet() {
        this.onDocumentCreate();
    }

    protected XSSFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    @Override
    protected void onDocumentRead() {
        try {
            this.read(this.getPackagePart().getInputStream());
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    protected void read(InputStream is) throws IOException {
        try {
            this.worksheet = WorksheetDocument.Factory.parse((InputStream)is).getWorksheet();
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        for (POIXMLDocumentPart p : this.getRelations()) {
            if (!(p instanceof CommentsTable)) continue;
            this.sheetComments = (CommentsTable)p;
        }
        this.initHyperlinks();
    }

    @Override
    protected void onDocumentCreate() {
        this.worksheet = XSSFSheet.newSheet();
        this.initRows(this.worksheet);
        this.columnHelper = new ColumnHelper(this.worksheet);
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
    }

    private void initRows(CTWorksheet worksheet) {
        this.rows = new TreeMap();
        this.sharedFormulas = new HashMap<Integer, XSSFCell>();
        for (CTRow row : worksheet.getSheetData().getRowArray()) {
            XSSFRow r = new XSSFRow(row, this);
            this.rows.put(r.getRowNum(), r);
        }
    }

    private void initHyperlinks() {
        this.hyperlinks = new ArrayList<XSSFHyperlink>();
        if (!this.worksheet.isSetHyperlinks()) {
            return;
        }
        try {
            PackageRelationshipCollection hyperRels = this.getPackagePart().getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
            for (CTHyperlink hyperlink : this.worksheet.getHyperlinks().getHyperlinkArray()) {
                PackageRelationship hyperRel = null;
                if (hyperlink.getId() != null) {
                    hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                }
                this.hyperlinks.add(new XSSFHyperlink(hyperlink, hyperRel));
            }
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
    }

    private static CTWorksheet newSheet() {
        CTWorksheet worksheet = CTWorksheet.Factory.newInstance();
        CTSheetFormatPr ctFormat = worksheet.addNewSheetFormatPr();
        ctFormat.setDefaultRowHeight(15.0);
        CTSheetView ctView = worksheet.addNewSheetViews().addNewSheetView();
        ctView.setWorkbookViewId(0L);
        worksheet.addNewDimension().setRef("A1");
        worksheet.addNewSheetData();
        CTPageMargins ctMargins = worksheet.addNewPageMargins();
        ctMargins.setBottom(0.75);
        ctMargins.setFooter(0.3);
        ctMargins.setHeader(0.3);
        ctMargins.setLeft(0.7);
        ctMargins.setRight(0.7);
        ctMargins.setTop(0.75);
        return worksheet;
    }

    public CTWorksheet getCTWorksheet() {
        return this.worksheet;
    }

    public ColumnHelper getColumnHelper() {
        return this.columnHelper;
    }

    public String getSheetName() {
        return this.sheet.getName();
    }

    public int addMergedRegion(CellRangeAddress cra) {
        cra.validate(SpreadsheetVersion.EXCEL2007);
        CTMergeCells ctMergeCells = this.worksheet.isSetMergeCells() ? this.worksheet.getMergeCells() : this.worksheet.addNewMergeCells();
        CTMergeCell ctMergeCell = ctMergeCells.addNewMergeCell();
        ctMergeCell.setRef(cra.formatAsString());
        return ctMergeCells.sizeOfMergeCellArray();
    }

    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = ColumnHelper.getColumnWidth(this, column, useMergedCells);
        if (width != -1.0) {
            this.columnHelper.setColBestFit(column, true);
            this.columnHelper.setCustomWidth(column, true);
            this.columnHelper.setColWidth(column, width);
        }
    }

    public XSSFDrawing createDrawingPatriarch() {
        XSSFDrawing drawing = null;
        CTDrawing ctDrawing = this.worksheet.getDrawing();
        if (ctDrawing == null) {
            int drawingNumber = this.getPackagePart().getPackage().getPartsByContentType(XSSFRelation.DRAWINGS.getContentType()).size() + 1;
            drawing = (XSSFDrawing)this.createRelationship(XSSFRelation.DRAWINGS, XSSFFactory.getInstance(), drawingNumber);
            String relId = drawing.getPackageRelationship().getId();
            ctDrawing = this.worksheet.addNewDrawing();
            ctDrawing.setId(relId);
        } else {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSSFDrawing)) continue;
                XSSFDrawing dr = (XSSFDrawing)p;
                String drId = dr.getPackageRelationship().getId();
                if (!drId.equals(ctDrawing.getId())) break;
                drawing = dr;
                break;
            }
            if (drawing == null) {
                logger.log(POILogger.ERROR, (Object)("Can't find drawing with id=" + ctDrawing.getId() + " in the list of the sheet's relationships"));
            }
        }
        return drawing;
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        CTPane pane = this.getPane();
        if (colSplit > 0) {
            pane.setXSplit((double)colSplit);
        }
        if (rowSplit > 0) {
            pane.setYSplit((double)rowSplit);
        }
        pane.setState(STPaneState.FROZEN);
        if (rowSplit == 0) {
            pane.setTopLeftCell(new CellReference(0, topRow).formatAsString());
            pane.setActivePane(STPane.TOP_RIGHT);
        } else if (colSplit == 0) {
            pane.setTopLeftCell(new CellReference(rowSplit, 0).formatAsString());
            pane.setActivePane(STPane.BOTTOM_LEFT);
        } else {
            pane.setTopLeftCell(new CellReference(leftmostColumn, topRow).formatAsString());
            pane.setActivePane(STPane.BOTTOM_RIGHT);
        }
        CTSheetView ctView = this.getDefaultSheetView();
        ctView.setSelectionArray(null);
        CTSelection sel = ctView.addNewSelection();
        sel.setPane(pane.getActivePane());
    }

    public XSSFComment createComment() {
        if (this.sheetComments == null) {
            this.sheetComments = (CommentsTable)this.createRelationship(XSSFRelation.SHEET_COMMENTS, XSSFFactory.getInstance(), (int)this.sheet.getSheetId());
        }
        return this.sheetComments.addComment();
    }

    public XSSFRow createRow(int rownum) {
        CTRow ctRow = CTRow.Factory.newInstance();
        XSSFRow r = new XSSFRow(ctRow, this);
        r.setRowNum(rownum);
        this.rows.put(r.getRowNum(), r);
        return r;
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.createFreezePane(xSplitPos, ySplitPos, leftmostColumn, topRow);
        this.getPane().setState(STPaneState.SPLIT);
        this.getPane().setActivePane(STPane.Enum.forInt((int)activePane));
    }

    public XSSFComment getCellComment(int row, int column) {
        if (this.sheetComments == null) {
            return null;
        }
        return this.sheetComments.findCellComment(row, column);
    }

    public XSSFHyperlink getHyperlink(int row, int column) {
        String ref = new CellReference(row, column).formatAsString();
        for (XSSFHyperlink hyperlink : this.hyperlinks) {
            if (!hyperlink.getCellRef().equals(ref)) continue;
            return hyperlink;
        }
        return null;
    }

    public int[] getColumnBreaks() {
        if (!this.worksheet.isSetColBreaks() || this.worksheet.getColBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getColBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId();
        }
        return breaks;
    }

    private CTPageBreak getSheetTypeColumnBreaks() {
        if (this.worksheet.getColBreaks() == null) {
            this.worksheet.setColBreaks(CTPageBreak.Factory.newInstance());
        }
        return this.worksheet.getColBreaks();
    }

    public int getColumnWidth(int columnIndex) {
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        double width = col == null || !col.isSetWidth() ? (double)this.getDefaultColumnWidth() : col.getWidth();
        return (int)(width * 256.0);
    }

    public int getDefaultColumnWidth() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return pr == null ? 8 : (int)pr.getBaseColWidth();
    }

    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    public float getDefaultRowHeightInPoints() {
        CTSheetFormatPr pr = this.worksheet.getSheetFormatPr();
        return (float)(pr == null ? 0.0 : pr.getDefaultRowHeight());
    }

    private CTSheetFormatPr getSheetTypeSheetFormatPr() {
        return this.worksheet.isSetSheetFormatPr() ? this.worksheet.getSheetFormatPr() : this.worksheet.addNewSheetFormatPr();
    }

    public CellStyle getColumnStyle(int column) {
        int idx = this.columnHelper.getColDefaultStyle(column);
        return this.getWorkbook().getCellStyleAt((short)(idx == -1 ? 0 : idx));
    }

    public boolean getDisplayGuts() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? CTOutlinePr.Factory.newInstance() : sheetPr.getOutlinePr();
        return outlinePr.getShowOutlineSymbols();
    }

    public void setDisplayGuts(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTOutlinePr outlinePr = sheetPr.getOutlinePr() == null ? sheetPr.addNewOutlinePr() : sheetPr.getOutlinePr();
        outlinePr.setShowOutlineSymbols(value);
    }

    public boolean isDisplayZeros() {
        CTSheetView view = this.getDefaultSheetView();
        return view == null ? true : view.getShowZeros();
    }

    public void setDisplayZeros(boolean value) {
        CTSheetView view = this.getSheetTypeSheetView();
        view.setShowZeros(value);
    }

    public int getFirstRowNum() {
        return this.rows.size() == 0 ? 0 : this.rows.firstKey();
    }

    public boolean getFitToPage() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getFitToPage();
    }

    private CTSheetPr getSheetTypeSheetPr() {
        if (this.worksheet.getSheetPr() == null) {
            this.worksheet.setSheetPr(CTSheetPr.Factory.newInstance());
        }
        return this.worksheet.getSheetPr();
    }

    private CTHeaderFooter getSheetTypeHeaderFooter() {
        if (this.worksheet.getHeaderFooter() == null) {
            this.worksheet.setHeaderFooter(CTHeaderFooter.Factory.newInstance());
        }
        return this.worksheet.getHeaderFooter();
    }

    public Footer getFooter() {
        return this.getOddFooter();
    }

    public Header getHeader() {
        return this.getOddHeader();
    }

    public Footer getOddFooter() {
        return new XSSFOddFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getEvenFooter() {
        return new XSSFEvenFooter(this.getSheetTypeHeaderFooter());
    }

    public Footer getFirstFooter() {
        return new XSSFFirstFooter(this.getSheetTypeHeaderFooter());
    }

    public Header getOddHeader() {
        return new XSSFOddHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getEvenHeader() {
        return new XSSFEvenHeader(this.getSheetTypeHeaderFooter());
    }

    public Header getFirstHeader() {
        return new XSSFFirstHeader(this.getSheetTypeHeaderFooter());
    }

    public boolean getHorizontallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getHorizontalCentered();
    }

    public int getLastRowNum() {
        return this.rows.size() == 0 ? 0 : this.rows.lastKey();
    }

    public short getLeftCol() {
        String cellRef = this.worksheet.getSheetViews().getSheetViewArray(0).getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return cellReference.getCol();
    }

    public double getMargin(short margin) {
        if (!this.worksheet.isSetPageMargins()) {
            return 0.0;
        }
        CTPageMargins pageMargins = this.worksheet.getPageMargins();
        switch (margin) {
            case 0: {
                return pageMargins.getLeft();
            }
            case 1: {
                return pageMargins.getRight();
            }
            case 2: {
                return pageMargins.getTop();
            }
            case 3: {
                return pageMargins.getBottom();
            }
            case 4: {
                return pageMargins.getHeader();
            }
            case 5: {
                return pageMargins.getFooter();
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + margin);
    }

    public void setMargin(short margin, double size) {
        CTPageMargins pageMargins = this.worksheet.isSetPageMargins() ? this.worksheet.getPageMargins() : this.worksheet.addNewPageMargins();
        switch (margin) {
            case 0: {
                pageMargins.setLeft(size);
                break;
            }
            case 1: {
                pageMargins.setRight(size);
                break;
            }
            case 2: {
                pageMargins.setTop(size);
                break;
            }
            case 3: {
                pageMargins.setBottom(size);
                break;
            }
            case 4: {
                pageMargins.setHeader(size);
                break;
            }
            case 5: {
                pageMargins.setFooter(size);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown margin constant:  " + margin);
            }
        }
    }

    public CellRangeAddress getMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        if (ctMergeCells == null) {
            throw new IllegalStateException("This worksheet does not contain merged regions");
        }
        CTMergeCell ctMergeCell = ctMergeCells.getMergeCellArray(index);
        String ref = ctMergeCell.getRef();
        return CellRangeAddress.valueOf((String)ref);
    }

    public int getNumMergedRegions() {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        return ctMergeCells == null ? 0 : ctMergeCells.sizeOfMergeCellArray();
    }

    public int getNumHyperlinks() {
        return this.hyperlinks.size();
    }

    public PaneInformation getPaneInformation() {
        CTPane pane = this.getPane();
        CellReference cellRef = pane.isSetTopLeftCell() ? new CellReference(pane.getTopLeftCell()) : null;
        return new PaneInformation((short)pane.getXSplit(), (short)pane.getYSplit(), (short)(cellRef == null ? 0 : cellRef.getRow()), cellRef == null ? (short)0 : cellRef.getCol(), (byte)pane.getActivePane().intValue(), pane.getState() == STPaneState.FROZEN);
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public XSSFPrintSetup getPrintSetup() {
        return new XSSFPrintSetup(this.worksheet);
    }

    public boolean getProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getSheet();
    }

    public XSSFRow getRow(int rownum) {
        return this.rows.get(rownum);
    }

    public int[] getRowBreaks() {
        if (!this.worksheet.isSetRowBreaks() || this.worksheet.getRowBreaks().sizeOfBrkArray() == 0) {
            return new int[0];
        }
        CTBreak[] brkArray = this.worksheet.getRowBreaks().getBrkArray();
        int[] breaks = new int[brkArray.length];
        for (int i = 0; i < brkArray.length; ++i) {
            CTBreak brk = brkArray[i];
            breaks[i] = (int)brk.getId();
        }
        return breaks;
    }

    public boolean getRowSumsBelow() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : null;
        return outlinePr == null || outlinePr.getSummaryBelow();
    }

    public void setRowSumsBelow(boolean value) {
        this.ensureOutlinePr().setSummaryBelow(value);
    }

    public boolean getRowSumsRight() {
        CTSheetPr sheetPr = this.worksheet.getSheetPr();
        CTOutlinePr outlinePr = sheetPr != null && sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : CTOutlinePr.Factory.newInstance();
        return outlinePr.getSummaryRight();
    }

    public void setRowSumsRight(boolean value) {
        this.ensureOutlinePr().setSummaryRight(value);
    }

    private CTOutlinePr ensureOutlinePr() {
        CTSheetPr sheetPr = this.worksheet.isSetSheetPr() ? this.worksheet.getSheetPr() : this.worksheet.addNewSheetPr();
        return sheetPr.isSetOutlinePr() ? sheetPr.getOutlinePr() : sheetPr.addNewOutlinePr();
    }

    public boolean getScenarioProtect() {
        return this.worksheet.isSetSheetProtection() && this.worksheet.getSheetProtection().getScenarios();
    }

    public short getTopRow() {
        String cellRef = this.getSheetTypeSheetView().getTopLeftCell();
        CellReference cellReference = new CellReference(cellRef);
        return (short)cellReference.getRow();
    }

    public boolean getVerticallyCenter() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getVerticalCentered();
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this.groupColumn1Based(fromColumn + 1, toColumn + 1);
    }

    private void groupColumn1Based(int fromColumn, int toColumn) {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol ctCol = CTCol.Factory.newInstance();
        ctCol.setMin((long)fromColumn);
        ctCol.setMax((long)toColumn);
        this.columnHelper.addCleanColIntoCols(ctCols, ctCol);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn1Based(index, false);
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel + 1));
            index = (int)col.getMax();
        }
        this.worksheet.setColsArray(0, ctCols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    public void groupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) {
                xrow = this.createRow(i);
            }
            CTRow ctrow = xrow.getCTRow();
            short outlineLevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlineLevel + 1));
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private short getMaxOutlineLevelRows() {
        short outlineLevel = 0;
        for (XSSFRow xrow : this.rows.values()) {
            outlineLevel = xrow.getCTRow().getOutlineLevel() > outlineLevel ? xrow.getCTRow().getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    private short getMaxOutlineLevelCols() {
        CTCols ctCols = this.worksheet.getColsArray(0);
        CTCol[] colArray = ctCols.getColArray();
        short outlineLevel = 0;
        for (CTCol col : colArray) {
            outlineLevel = col.getOutlineLevel() > outlineLevel ? col.getOutlineLevel() : outlineLevel;
        }
        return outlineLevel;
    }

    public boolean isColumnBroken(int column) {
        int[] colBreaks = this.getColumnBreaks();
        for (int i = 0; i < colBreaks.length; ++i) {
            if (colBreaks[i] != column) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnHidden(int columnIndex) {
        return this.columnHelper.getColumn(columnIndex, false).getHidden();
    }

    public boolean isDisplayFormulas() {
        return this.getSheetTypeSheetView().getShowFormulas();
    }

    public boolean isDisplayGridlines() {
        return this.getSheetTypeSheetView().getShowGridLines();
    }

    public void setDisplayGridlines(boolean show) {
        this.getSheetTypeSheetView().setShowGridLines(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.getSheetTypeSheetView().getShowRowColHeaders();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.getSheetTypeSheetView().setShowRowColHeaders(show);
    }

    public boolean isPrintGridlines() {
        CTPrintOptions opts = this.worksheet.getPrintOptions();
        return opts != null && opts.getGridLines();
    }

    public void setPrintGridlines(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setGridLines(value);
    }

    public boolean isRowBroken(int row) {
        int[] rowBreaks = this.getRowBreaks();
        for (int i = 0; i < rowBreaks.length; ++i) {
            if (rowBreaks[i] != row) continue;
            return true;
        }
        return false;
    }

    public void setRowBreak(int row) {
        CTPageBreak pgBreak;
        CTPageBreak cTPageBreak = pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
        if (!this.isRowBroken(row)) {
            CTBreak brk = pgBreak.addNewBrk();
            brk.setId((long)row);
        }
    }

    public void removeColumnBreak(int column) {
        CTBreak[] brkArray = this.getSheetTypeColumnBreaks().getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)column) continue;
            this.getSheetTypeColumnBreaks().removeBrk(i);
        }
    }

    public void removeMergedRegion(int index) {
        CTMergeCells ctMergeCells = this.worksheet.getMergeCells();
        CTMergeCell[] mergeCellsArray = new CTMergeCell[ctMergeCells.sizeOfMergeCellArray() - 1];
        for (int i = 0; i < ctMergeCells.sizeOfMergeCellArray(); ++i) {
            if (i < index) {
                mergeCellsArray[i] = ctMergeCells.getMergeCellArray(i);
                continue;
            }
            if (i <= index) continue;
            mergeCellsArray[i - 1] = ctMergeCells.getMergeCellArray(i);
        }
        ctMergeCells.setMergeCellArray(mergeCellsArray);
    }

    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        this.rows.remove(row.getRowNum());
    }

    public void removeRowBreak(int row) {
        CTPageBreak pgBreak = this.worksheet.isSetRowBreaks() ? this.worksheet.getRowBreaks() : this.worksheet.addNewRowBreaks();
        CTBreak[] brkArray = pgBreak.getBrkArray();
        for (int i = 0; i < brkArray.length; ++i) {
            if (brkArray[i].getId() != (long)row) continue;
            pgBreak.removeBrk(i);
        }
    }

    public Iterator<Row> rowIterator() {
        return this.rows.values().iterator();
    }

    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    public boolean getAutobreaks() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr == null || !sheetPr.isSetPageSetUpPr() ? CTPageSetUpPr.Factory.newInstance() : sheetPr.getPageSetUpPr();
        return psSetup.getAutoPageBreaks();
    }

    public void setAutobreaks(boolean value) {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        CTPageSetUpPr psSetup = sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
        psSetup.setAutoPageBreaks(value);
    }

    public void setColumnBreak(int column) {
        if (!this.isColumnBroken(column)) {
            CTBreak brk = this.getSheetTypeColumnBreaks().addNewBrk();
            brk.setId((long)column);
        }
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        if (collapsed) {
            this.collapseColumn(columnNumber);
        } else {
            this.expandColumn(columnNumber);
        }
    }

    private void collapseColumn(int columnNumber) {
        CTCol col;
        CTCols cols = this.worksheet.getColsArray(0);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col = this.columnHelper.getColumn(columnNumber, false));
        if (colInfoIx == -1) {
            return;
        }
        int groupStartColInfoIx = this.findStartOfColumnOutlineGroup(colInfoIx);
        CTCol columnInfo = cols.getColArray(groupStartColInfoIx);
        int lastColMax = this.setGroupHidden(groupStartColInfoIx, columnInfo.getOutlineLevel(), true);
        this.setColumn(lastColMax + 1, null, 0, null, null, Boolean.TRUE);
    }

    private void setColumn(int targetColumnIx, Short xfIndex, Integer style, Integer level, Boolean hidden, Boolean collapsed) {
        boolean columnChanged;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol ci = null;
        int k = 0;
        for (k = 0; k < cols.sizeOfColArray(); ++k) {
            CTCol tci = cols.getColArray(k);
            if (tci.getMin() >= (long)targetColumnIx && tci.getMax() <= (long)targetColumnIx) {
                ci = tci;
                break;
            }
            if (tci.getMin() > (long)targetColumnIx) break;
        }
        if (ci == null) {
            CTCol nci = CTCol.Factory.newInstance();
            nci.setMin((long)targetColumnIx);
            nci.setMax((long)targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
            return;
        }
        boolean styleChanged = style != null && ci.getStyle() != (long)style.intValue();
        boolean levelChanged = level != null && ci.getOutlineLevel() != level.intValue();
        boolean hiddenChanged = hidden != null && ci.getHidden() != hidden.booleanValue();
        boolean collapsedChanged = collapsed != null && ci.getCollapsed() != collapsed.booleanValue();
        boolean bl = columnChanged = levelChanged || hiddenChanged || collapsedChanged || styleChanged;
        if (!columnChanged) {
            return;
        }
        if (ci.getMin() == (long)targetColumnIx && ci.getMax() == (long)targetColumnIx) {
            this.unsetCollapsed(collapsed, ci);
            return;
        }
        if (ci.getMin() == (long)targetColumnIx || ci.getMax() == (long)targetColumnIx) {
            if (ci.getMin() == (long)targetColumnIx) {
                ci.setMin((long)(targetColumnIx + 1));
            } else {
                ci.setMax((long)(targetColumnIx - 1));
                ++k;
            }
            CTCol nci = this.columnHelper.cloneCol(cols, ci);
            nci.setMin((long)targetColumnIx);
            this.unsetCollapsed(collapsed, nci);
            this.columnHelper.addCleanColIntoCols(cols, nci);
        } else {
            CTCol ciStart = ci;
            CTCol ciMid = this.columnHelper.cloneCol(cols, ci);
            CTCol ciEnd = this.columnHelper.cloneCol(cols, ci);
            int lastcolumn = (int)ci.getMax();
            ciStart.setMax((long)(targetColumnIx - 1));
            ciMid.setMin((long)targetColumnIx);
            ciMid.setMax((long)targetColumnIx);
            this.unsetCollapsed(collapsed, ciMid);
            this.columnHelper.addCleanColIntoCols(cols, ciMid);
            ciEnd.setMin((long)(targetColumnIx + 1));
            ciEnd.setMax((long)lastcolumn);
            this.columnHelper.addCleanColIntoCols(cols, ciEnd);
        }
    }

    private void unsetCollapsed(boolean collapsed, CTCol ci) {
        if (collapsed) {
            ci.setCollapsed(collapsed);
        } else {
            ci.unsetCollapsed();
        }
    }

    private int setGroupHidden(int pIdx, int level, boolean hidden) {
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(idx);
        for (idx = pIdx; idx < cols.sizeOfColArray(); ++idx) {
            columnInfo.setHidden(hidden);
            if (idx + 1 >= cols.sizeOfColArray()) continue;
            CTCol nextColumnInfo = cols.getColArray(idx + 1);
            if (!this.isAdjacentBefore(columnInfo, nextColumnInfo) || nextColumnInfo.getOutlineLevel() < level) break;
            columnInfo = nextColumnInfo;
        }
        return (int)columnInfo.getMax();
    }

    private boolean isAdjacentBefore(CTCol col, CTCol other_col) {
        return col.getMax() == other_col.getMin() - 1L;
    }

    private int findStartOfColumnOutlineGroup(int pIdx) {
        CTCol prevColumnInfo;
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(pIdx);
        short level = columnInfo.getOutlineLevel();
        for (idx = pIdx; idx != 0 && this.isAdjacentBefore(prevColumnInfo = cols.getColArray(idx - 1), columnInfo) && prevColumnInfo.getOutlineLevel() >= level; --idx) {
            columnInfo = prevColumnInfo;
        }
        return idx;
    }

    private int findEndOfColumnOutlineGroup(int colInfoIndex) {
        CTCol nextColumnInfo;
        int idx;
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol columnInfo = cols.getColArray(colInfoIndex);
        short level = columnInfo.getOutlineLevel();
        for (idx = colInfoIndex; idx < cols.sizeOfColArray() - 1 && this.isAdjacentBefore(columnInfo, nextColumnInfo = cols.getColArray(idx + 1)) && nextColumnInfo.getOutlineLevel() >= level; ++idx) {
            columnInfo = nextColumnInfo;
        }
        return idx;
    }

    private void expandColumn(int columnIndex) {
        CTCols cols = this.worksheet.getColsArray(0);
        CTCol col = this.columnHelper.getColumn(columnIndex, false);
        int colInfoIx = this.columnHelper.getIndexOfColumn(cols, col);
        int idx = this.findColInfoIdx((int)col.getMax(), colInfoIx);
        if (idx == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfColumnOutlineGroup(idx);
        int endIdx = this.findEndOfColumnOutlineGroup(idx);
        CTCol columnInfo = cols.getColArray(endIdx);
        if (!this.isColumnGroupHiddenByParent(idx)) {
            short outlineLevel = columnInfo.getOutlineLevel();
            boolean nestedGroup = false;
            for (int i = startIdx; i <= endIdx; ++i) {
                CTCol ci = cols.getColArray(i);
                if (outlineLevel == ci.getOutlineLevel()) {
                    ci.unsetHidden();
                    if (!nestedGroup) continue;
                    nestedGroup = false;
                    ci.setCollapsed(true);
                    continue;
                }
                nestedGroup = true;
            }
        }
        this.setColumn((int)columnInfo.getMax() + 1, null, null, null, Boolean.FALSE, Boolean.FALSE);
    }

    private boolean isColumnGroupHiddenByParent(int idx) {
        CTCol prevInfo;
        CTCols cols = this.worksheet.getColsArray(0);
        short endLevel = 0;
        boolean endHidden = false;
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx < cols.sizeOfColArray()) {
            CTCol nextInfo = cols.getColArray(endOfOutlineGroupIdx + 1);
            if (this.isAdjacentBefore(cols.getColArray(endOfOutlineGroupIdx), nextInfo)) {
                endLevel = nextInfo.getOutlineLevel();
                endHidden = nextInfo.getHidden();
            }
        }
        short startLevel = 0;
        boolean startHidden = false;
        int startOfOutlineGroupIdx = this.findStartOfColumnOutlineGroup(idx);
        if (startOfOutlineGroupIdx > 0 && this.isAdjacentBefore(prevInfo = cols.getColArray(startOfOutlineGroupIdx - 1), cols.getColArray(startOfOutlineGroupIdx))) {
            startLevel = prevInfo.getOutlineLevel();
            startHidden = prevInfo.getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private int findColInfoIdx(int columnValue, int fromColInfoIdx) {
        CTCols cols = this.worksheet.getColsArray(0);
        if (columnValue < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + columnValue);
        }
        if (fromColInfoIdx < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + fromColInfoIdx);
        }
        for (int k = fromColInfoIdx; k < cols.sizeOfColArray(); ++k) {
            CTCol ci = cols.getColArray(k);
            if (this.containsColumn(ci, columnValue)) {
                return k;
            }
            if (ci.getMin() > (long)fromColInfoIdx) break;
        }
        return -1;
    }

    private boolean containsColumn(CTCol col, int columnIndex) {
        return col.getMin() <= (long)columnIndex && (long)columnIndex <= col.getMax();
    }

    private boolean isColumnGroupCollapsed(int idx) {
        CTCols cols = this.worksheet.getColsArray(0);
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        int nextColInfoIx = endOfOutlineGroupIdx + 1;
        if (nextColInfoIx >= cols.sizeOfColArray()) {
            return false;
        }
        CTCol nextColInfo = cols.getColArray(nextColInfoIx);
        CTCol col = cols.getColArray(endOfOutlineGroupIdx);
        if (!this.isAdjacentBefore(col, nextColInfo)) {
            return false;
        }
        return nextColInfo.getCollapsed();
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.columnHelper.setColHidden(columnIndex, hidden);
    }

    public void setColumnWidth(int columnIndex, int width) {
        if (width > 65280) {
            throw new IllegalArgumentException("The maximum column width for an individual cell is 255 characters.");
        }
        this.columnHelper.setColWidth(columnIndex, (double)width / 256.0);
        this.columnHelper.setCustomWidth(columnIndex, true);
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.columnHelper.setColDefaultStyle((long)column, style);
    }

    public void setDefaultColumnWidth(int width) {
        this.getSheetTypeSheetFormatPr().setBaseColWidth((long)width);
    }

    public void setDefaultRowHeight(short height) {
        this.getSheetTypeSheetFormatPr().setDefaultRowHeight((double)height / 20.0);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this.getSheetTypeSheetFormatPr().setDefaultRowHeight((double)height);
    }

    public void setDisplayFormulas(boolean show) {
        this.getSheetTypeSheetView().setShowFormulas(show);
    }

    private CTSheetView getSheetTypeSheetView() {
        if (this.getDefaultSheetView() == null) {
            this.getSheetTypeSheetViews().setSheetViewArray(0, CTSheetView.Factory.newInstance());
        }
        return this.getDefaultSheetView();
    }

    public void setFitToPage(boolean b) {
        this.getSheetTypePageSetUpPr().setFitToPage(b);
    }

    public void setHorizontallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setHorizontalCentered(value);
    }

    public void setVerticallyCenter(boolean value) {
        CTPrintOptions opts = this.worksheet.isSetPrintOptions() ? this.worksheet.getPrintOptions() : this.worksheet.addNewPrintOptions();
        opts.setVerticalCentered(value);
    }

    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this.collapseRow(rowIndex);
        } else {
            this.expandRow(rowIndex);
        }
    }

    private void collapseRow(int rowIndex) {
        XSSFRow row = this.getRow(rowIndex);
        if (row != null) {
            int startRow = this.findStartOfRowOutlineGroup(rowIndex);
            int lastRow = this.writeHidden(row, startRow, true);
            if (this.getRow(lastRow) != null) {
                this.getRow(lastRow).getCTRow().setCollapsed(true);
            } else {
                XSSFRow newRow = this.createRow(lastRow);
                newRow.getCTRow().setCollapsed(true);
            }
        }
    }

    private int findStartOfRowOutlineGroup(int rowIndex) {
        short level = this.getRow(rowIndex).getCTRow().getOutlineLevel();
        int currentRow = rowIndex;
        while (this.getRow(currentRow) != null) {
            if (this.getRow(currentRow).getCTRow().getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow;
    }

    private int writeHidden(XSSFRow xRow, int rowIndex, boolean hidden) {
        short level = xRow.getCTRow().getOutlineLevel();
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            xRow = (XSSFRow)it.next();
            if (xRow.getCTRow().getOutlineLevel() < level) continue;
            xRow.getCTRow().setHidden(hidden);
            ++rowIndex;
        }
        return rowIndex;
    }

    private void expandRow(int rowNumber) {
        if (rowNumber == -1) {
            return;
        }
        XSSFRow row = this.getRow(rowNumber);
        if (!row.getCTRow().isSetHidden()) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(rowNumber);
        int endIdx = this.findEndOfRowOutlineGroup(rowNumber);
        if (!this.isRowGroupHiddenByParent(rowNumber)) {
            for (int i = startIdx; i < endIdx; ++i) {
                if (row.getCTRow().getOutlineLevel() == this.getRow(i).getCTRow().getOutlineLevel()) {
                    this.getRow(i).getCTRow().unsetHidden();
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).getCTRow().unsetHidden();
            }
        }
        this.getRow(endIdx).getCTRow().unsetCollapsed();
    }

    public int findEndOfRowOutlineGroup(int row) {
        int currentRow;
        short level = this.getRow(row).getCTRow().getOutlineLevel();
        for (currentRow = row; currentRow < this.getLastRowNum() && this.getRow(currentRow) != null && this.getRow(currentRow).getCTRow().getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow;
    }

    private boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getRow(endOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            endHidden = this.getRow(endOfOutlineGroupIdx).getCTRow().getHidden();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx < 0 || this.getRow(startOfOutlineGroupIdx) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getRow(startOfOutlineGroupIdx).getCTRow().getOutlineLevel();
            startHidden = this.getRow(startOfOutlineGroupIdx).getCTRow().getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    private boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return this.getRow(collapseRow).getCTRow().getCollapsed();
    }

    public void setZoom(int numerator, int denominator) {
        int zoom = 100 * numerator / denominator;
        this.setZoom(zoom);
    }

    public void setZoom(int scale) {
        if (scale < 10 || scale > 400) {
            throw new IllegalArgumentException("Valid scale values range from 10 to 400");
        }
        this.getSheetTypeSheetView().setZoomScale((long)scale);
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.shiftRows(startRow, endRow, n, false, false);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        Iterator<Row> it = this.rowIterator();
        while (it.hasNext()) {
            XSSFRow row = (XSSFRow)it.next();
            int rownum = row.getRowNum();
            if (rownum < startRow) continue;
            if (!copyRowHeight) {
                row.setHeight((short)-1);
            }
            if (this.removeRow(startRow, endRow, n, rownum)) {
                it.remove();
            } else if (rownum >= startRow && rownum <= endRow) {
                row.shift(n);
            }
            if (this.sheetComments == null) continue;
            CTCommentList lst = this.sheetComments.getCTComments().getCommentList();
            for (CTComment comment : lst.getCommentArray()) {
                CellReference ref = new CellReference(comment.getRef());
                if (ref.getRow() != rownum) continue;
                ref = new CellReference(rownum + n, ref.getCol());
                comment.setRef(ref.formatAsString());
            }
        }
        XSSFRowShifter rowShifter = new XSSFRowShifter(this);
        int sheetIndex = this.getWorkbook().getSheetIndex(this);
        FormulaShifter shifter = FormulaShifter.createForRowShift((int)sheetIndex, (int)startRow, (int)endRow, (int)n);
        rowShifter.updateNamedRanges(shifter);
        rowShifter.updateFormulas(shifter);
        rowShifter.shiftMerged(startRow, endRow, n);
        TreeMap<Integer, XSSFRow> map = new TreeMap<Integer, XSSFRow>();
        for (XSSFRow r : this.rows.values()) {
            map.put(r.getRowNum(), r);
        }
        this.rows = map;
    }

    public void showInPane(short toprow, short leftcol) {
        CellReference cellReference = new CellReference((int)toprow, leftcol);
        String cellRef = cellReference.formatAsString();
        this.getPane().setTopLeftCell(cellRef);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        CTCols cols = this.worksheet.getColsArray(0);
        for (int index = fromColumn; index <= toColumn; ++index) {
            CTCol col = this.columnHelper.getColumn(index, false);
            if (col == null) continue;
            short outlineLevel = col.getOutlineLevel();
            col.setOutlineLevel((short)(outlineLevel - 1));
            index = (int)col.getMax();
            if (col.getOutlineLevel() > 0) continue;
            int colIndex = this.columnHelper.getIndexOfColumn(cols, col);
            this.worksheet.getColsArray(0).removeCol(colIndex);
        }
        this.worksheet.setColsArray(0, cols);
        this.setSheetFormatPrOutlineLevelCol();
    }

    public void ungroupRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            XSSFRow xrow = this.getRow(i);
            if (xrow == null) continue;
            CTRow ctrow = xrow.getCTRow();
            short outlinelevel = ctrow.getOutlineLevel();
            ctrow.setOutlineLevel((short)(outlinelevel - 1));
            if (ctrow.getOutlineLevel() != 0 || xrow.getFirstCellNum() != -1) continue;
            this.removeRow(xrow);
        }
        this.setSheetFormatPrOutlineLevelRow();
    }

    private void setSheetFormatPrOutlineLevelRow() {
        short maxLevelRow = this.getMaxOutlineLevelRows();
        this.getSheetTypeSheetFormatPr().setOutlineLevelRow(maxLevelRow);
    }

    private void setSheetFormatPrOutlineLevelCol() {
        short maxLevelCol = this.getMaxOutlineLevelCols();
        this.getSheetTypeSheetFormatPr().setOutlineLevelCol(maxLevelCol);
    }

    private CTSheetViews getSheetTypeSheetViews() {
        if (this.worksheet.getSheetViews() == null) {
            this.worksheet.setSheetViews(CTSheetViews.Factory.newInstance());
            this.worksheet.getSheetViews().addNewSheetView();
        }
        return this.worksheet.getSheetViews();
    }

    public boolean isSelected() {
        CTSheetView view = this.getDefaultSheetView();
        return view != null && view.getTabSelected();
    }

    public void setSelected(boolean value) {
        CTSheetViews views = this.getSheetTypeSheetViews();
        for (CTSheetView view : views.getSheetViewArray()) {
            view.setTabSelected(value);
        }
    }

    public void setCellComment(String cellRef, XSSFComment comment) {
        CellReference cellReference = new CellReference(cellRef);
        comment.setRow(cellReference.getRow());
        comment.setColumn(cellReference.getCol());
    }

    protected void setCellHyperlink(XSSFHyperlink hyperlink) {
        this.hyperlinks.add(hyperlink);
    }

    public String getActiveCell() {
        return this.getSheetTypeSelection().getActiveCell();
    }

    public void setActiveCell(String cellRef) {
        CTSelection ctsel = this.getSheetTypeSelection();
        ctsel.setActiveCell(cellRef);
        ctsel.setSqref(Arrays.asList(cellRef));
    }

    public boolean hasComments() {
        if (this.sheetComments == null) {
            return false;
        }
        return this.sheetComments.getNumberOfComments() > 0;
    }

    protected int getNumberOfComments() {
        if (this.sheetComments == null) {
            return 0;
        }
        return this.sheetComments.getNumberOfComments();
    }

    private CTSelection getSheetTypeSelection() {
        if (this.getSheetTypeSheetView().sizeOfSelectionArray() == 0) {
            this.getSheetTypeSheetView().insertNewSelection(0);
        }
        return this.getSheetTypeSheetView().getSelectionArray(0);
    }

    private CTSheetView getDefaultSheetView() {
        CTSheetViews views = this.getSheetTypeSheetViews();
        if (views == null || views.getSheetViewArray() == null || views.getSheetViewArray().length <= 0) {
            return null;
        }
        return views.getSheetViewArray(views.getSheetViewArray().length - 1);
    }

    protected CommentsTable getCommentsTable() {
        return this.sheetComments;
    }

    private CTPageSetUpPr getSheetTypePageSetUpPr() {
        CTSheetPr sheetPr = this.getSheetTypeSheetPr();
        return sheetPr.isSetPageSetUpPr() ? sheetPr.getPageSetUpPr() : sheetPr.addNewPageSetUpPr();
    }

    private boolean removeRow(int startRow, int endRow, int n, int rownum) {
        if (rownum >= startRow + n && rownum <= endRow + n) {
            if (n > 0 && rownum > endRow) {
                return true;
            }
            if (n < 0 && rownum < startRow) {
                return true;
            }
        }
        return false;
    }

    private CTPane getPane() {
        if (this.getDefaultSheetView().getPane() == null) {
            this.getDefaultSheetView().addNewPane();
        }
        return this.getDefaultSheetView().getPane();
    }

    XSSFCell getSharedFormulaCell(int sid) {
        return this.sharedFormulas.get(sid);
    }

    void onReadCell(XSSFCell cell) {
        CTCell ct = cell.getCTCell();
        CTCellFormula f = ct.getF();
        if (f != null && f.getT() == STCellFormulaType.SHARED && f.isSetRef() && f.getStringValue() != null) {
            this.sharedFormulas.put((int)f.getSi(), cell);
        }
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.write(out);
        out.close();
    }

    protected void write(OutputStream out) throws IOException {
        CTCols col;
        CTCol[] cols;
        if (this.worksheet.getColsArray().length == 1 && (cols = (col = this.worksheet.getColsArray(0)).getColArray()).length == 0) {
            this.worksheet.setColsArray(null);
        }
        if (this.hyperlinks.size() > 0) {
            if (this.worksheet.getHyperlinks() == null) {
                this.worksheet.addNewHyperlinks();
            }
            CTHyperlink[] ctHls = new CTHyperlink[this.hyperlinks.size()];
            for (int i = 0; i < ctHls.length; ++i) {
                XSSFHyperlink hyperlink = this.hyperlinks.get(i);
                hyperlink.generateRelationIfNeeded(this.getPackagePart());
                ctHls[i] = hyperlink.getCTHyperlink();
            }
            this.worksheet.getHyperlinks().setHyperlinkArray(ctHls);
        }
        CTSheetData sheetData = this.worksheet.getSheetData();
        ArrayList<CTRow> rArray = new ArrayList<CTRow>(this.rows.size());
        for (XSSFRow row : this.rows.values()) {
            row.onDocumentWrite();
            rArray.add(row.getCTRow());
        }
        sheetData.setRowArray(rArray.toArray(new CTRow[rArray.size()]));
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        xmlOptions.setSaveSuggestedPrefixes(map);
        this.worksheet.save(out, xmlOptions);
    }
}

