% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_style.R
\name{auto_style_number_formatting}
\alias{auto_style_number_formatting}
\title{Use the data type of the columns to choose an automatic Excel format for body cells}
\usage{
auto_style_number_formatting(tab, overrides = list())
}
\arguments{
\item{tab}{a table object}

\item{overrides}{a list containing any manual overrides where the user wants to provide their own style name}
}
\description{
This function reads styling from the styles defined \href{https://github.com/moj-analytical-services/xltabr/blob/master/inst/extdata/number_format_defaults.csv}{here}
}
\examples{
body_data <- readRDS(system.file("extdata", "test_number_types.rds", package="xltabr"))
tab <- initialise()
tab <- add_body(tab, body_data)
tab <- auto_style_number_formatting(tab)
}
