% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{add_body}
\alias{add_body}
\title{Add a table body (a df) to the tab.}
\usage{
add_body(tab, df, left_header_colnames = NULL, row_style_names = NULL,
  left_header_style_names = NULL, col_style_names = NULL,
  fill_non_values_with = list(na = NULL, nan = NULL, inf = NULL, neg_inf =
  NULL))
}
\arguments{
\item{tab}{The core tab object}

\item{df}{A data frame containing the data you want to write to write to Excel}

\item{left_header_colnames}{The names of the columns in the df which are left headers, as opposed to the main body}

\item{row_style_names}{Manually specify the styles that apply to each row (as opposed to using the autodetect functions).  Styles provided must be present in the style catalogue}

\item{left_header_style_names}{Manually specify the addition styles that will apply to cells in the left headers.  Must be present in styles catalogue}

\item{col_style_names}{Manually specify the additional styles that will be applied to each column.  Must be present in styles catalogue}

\item{fill_non_values_with}{Manually specify a list of strings that will replace non numbers types NA, NaN, Inf and -Inf. e.g. list(na = '*', nan = '', inf = '-', neg_inf = '--'). Note: NaNs are not treated as NAs.}
}
\description{
Add a table body (a df) to the tab.
}
\examples{
crosstab <- read.csv(system.file("extdata", "example_crosstab.csv", package="xltabr"))
tab <- initialise()

# Note you could also use xltabr::auto_detect_left_headers
colnames <- c("drive", "age")
lh_styles <- "left_header"
tab <- add_body(tab, crosstab, left_header_colnames = colnames, left_header_style_names = lh_styles)
}
