% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_style.R
\name{auto_detect_body_title_level}
\alias{auto_detect_body_title_level}
\title{Autodetect the 'title level' of each row in the cross tabulation
e.g. title 1 is most prominent, title 2 next etc.}
\usage{
auto_detect_body_title_level(tab, keyword = "(all)",
  allcount_to_level_translate = NULL)
}
\arguments{
\item{tab}{a tab object}

\item{keyword}{The keyword to use to detect summarisation.  Uses '(all)' by default because this is what reshape2::dcast uses}

\item{allcount_to_level_translate}{A named vector that provides a lookup - by default c("0" = NA, "1" = 5, "2" = 4, "3" = 3, "4" = 2, "5" = 1), which says that e.g. allcount 1 results in title_5 etc}
}
\description{
Uses the presence of '(all)' to detect the prominence.  The parameter allcount_to_level_translate allows the user to control how the count of '(all)' in the left header is translated into the header level
}
\examples{
crosstab <- read.csv(system.file("extdata", "example_crosstab.csv", package="xltabr"))
tab <- initialise()
tab <- add_body(tab, crosstab, left_header_colnames = c("drive", "age"))
tab <- auto_detect_body_title_level(tab)
}
