% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/xml_name.R
\name{xml_name}
\alias{xml_name}
\title{The (tag) name of an xml element.}
\usage{
xml_name(x, ns = character())
}
\arguments{
\item{x}{A document, node, or node set.}

\item{ns}{Optionally, a named vector giving prefix-url pairs, as produced
by \code{\link{xml_ns}}. If provided, all names will be explicitly
qualified with the ns prefix, i.e. if the element \code{bar} is defined
in namespace \code{foo}, it will be called \code{foo:bar}. (And
similarly for atttributes). Default namespaces must be given an explicit
name.}
}
\value{
A character vector.
}
\description{
The (tag) name of an xml element.
}
\examples{
x <- read_xml("<bar>123</bar>")
xml_name(x)

y <- read_xml("<bar><baz>1</baz>abc<foo /></bar>")
z <- xml_children(y)
xml_name(xml_children(y))
}

