% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{xportr_label}
\alias{xportr_label}
\title{Assign Variable Label}
\usage{
xportr_label(
  .df,
  metacore,
  domain = NULL,
  verbose = getOption("xportr.label_verbose", "none")
)
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metacore}{A data frame containing variable level metadata.}

\item{domain}{A character value to subset the \code{.df}. If \code{NULL}(default), uses
\code{.df} value as a subset condition.}

\item{verbose}{The action the function takes when a variable length isn't
Found. Options are 'stop', 'warn', 'message', and 'none'}
}
\value{
Data frame with label attributes for each variable.
}
\description{
Assigns variable label from a variable level metadata to a given data frame.
}
\examples{
adsl <- data.frame(
  USUBJID = c(1001, 1002, 1003),
  SITEID = c(001, 002, 003),
  AGE = c(63, 35, 27),
  SEX = c("M", "F", "M")
)

metacore <- data.frame(
  dataset = "adsl",
  variable = c("USUBJID", "SITEID", "AGE", "SEX"),
  label = c("Unique Subject Identifier", "Study Site Identifier", "Age", "Sex")
)

adsl <- xportr_label(adsl, metacore)
}
\seealso{
\code{\link[=xportr_df_label]{xportr_df_label()}}, \code{\link[=xportr_format]{xportr_format()}} and \code{\link[=xportr_length]{xportr_length()}}

Other metadata functions: 
\code{\link{xportr_df_label}()},
\code{\link{xportr_format}()},
\code{\link{xportr_length}()}
}
\concept{metadata functions}
