;; Description: Prop Odds Model and (mock) dataset from:
;; Lu T, Yang Y, Jin JY, Kgedal M. Analysis of 
;; Longitudinal-Ordered Categorical Data for Muscle 
;; Spasm Adverse Event of Vismodegib: Comparison 
;; Between Different Pharmacometric Models. 
;; CPT Pharmacometrics Syst Pharmacol. 2020 Feb;9(2):96-105. 
;; doi: 10.1002/psp4.12487.
$SIZES NO=500
	LIM6=500
$PROB LOGISTIC MODEL FOR ORDERED CATEGORICAL DATA
$INPUT C STUDY COHORT PTNM ID TIME EVID AMT DV MDV CMT FRMU BAAG AGE BWT PTS
$DATA muscle_spasm_PO_weekly2.csv IGNORE=C
$SUBROUTINE ADVAN6 TOL=9
$MODEL
	COMP = (GUT)	;CMT1
	COMP = (TOTAL)	;CMT2
	COMP = (UNBOUND)	;CMT3
	COMP = (EFFECT)	;CMT4
$PK
;PK section
	; molecular weight
	MW = 421.3
	; new variables
	HV = 0
	IF (PTS.EQ.0) HV = 1
	FM = 0
	IF (FRMU.EQ.1) FM = 1
	; covariates
	SAGE = THETA(9)*LOG(AGE/60)
	SWT = THETA(10)*LOG(BWT/75)
	; unbound clearance (L/day)
	CL = EXP(THETA(1)+SAGE)
	; central volume (L)
	V = EXP(THETA(2)+SWT)
	; dissociation constant (uM)
	KD = EXP(THETA(3))
	; Absorption rate constant (1/day)
	KA = EXP(THETA(4)+HV*THETA(5)+FM*THETA(8))
	; Bioavailability 
	F1 = 1
	IF(FRMU.EQ.1) F1 = EXP(THETA(6)+HV*THETA(7))

;AE section
	; Effect site rate constant
	KE0 = EXP(THETA(11))
	B0=10
	B1 = THETA(12)	; LOGIT(P(AE>=1))
	B2 = B1+THETA(13)	; LOGIT(P(AE>=2))
	; ER relationship
	SLP=THETA(14)*EXP(ETA(1))

$DES
	; abs site (mg/day)
	DADT(1) = -KA*A(1)
	GI = A(1)
	; unbound drug + drug-AAG (uM)
	CTOT = (A(2)*1000/MW)/V
	T1 = BAAG - CTOT + KD
	U449 = (-T1 + SQRT(T1**2 + 4*CTOT*KD))/2
	; total drug (mg/day)
	DADT(2) = KA*A(1) - CL*U449*MW/1000
	DADT(4) = KE0*U449 - KE0*A(4)

$ERROR
	CTOTE = (A(2)*1000/MW)/V
	T1E = BAAG - CTOTE + KD
	U449E = (-T1E + SQRT(T1E**2 + 4*CTOTE*KD))/2
	CE = A(4)
	EFF = SLP * A(4)

	; LGT0=LOGIT P(PR<=0)
	LGT1 = B1+EFF
	LGT2 = B2+EFF

	PGE0 = 1
	PGE1 = EXP(LGT1)/(1+EXP(LGT1))
	PGE2 = EXP(LGT2)/(1+EXP(LGT2))

	P0 = PGE0-PGE1
	P1 = PGE1-PGE2
	P23 = PGE2

	Y=-1
	IF (DV.EQ.0)  Y=P0
	IF (DV.EQ.1)  Y=P1
	IF (DV.EQ.2)  Y=P23
	IF (DV.EQ.3)  Y=P23

$THETA
	7.19 FIXED	;THETA1_LN(CL/F)_L/day
	4.06 FIXED	 ;THETA2_LN(V/F)_L
	-2.88 FIXED	;THETA3_LN(KDAAG)_uM
	2.2 FIXED	 ;THETA4_LN(KA)
	0.671 FIXED	;THETA5_population on Ka
	-1.06 FIXED	;THETA6_LN(F1)
	0.881 FIXED	;THETA7_population on F
	-0.602 FIXED ;THETA8_formulation on Ka
	-0.527 FIXED ;THETA9_age on CL
	0.66 FIXED	;THETA10_weight on V

	(-10,-1,5)	; LOG(KE0) THETA11; final estimate (weekly): -3.38 or 0.034 in normal scale
	(-10,-1,4)	; THETA(12) ; B1: baseline of LOGIT(P(AE>=1)); final estimate (weekly): -4.03
	(-10,-1,0) 	; THETA(13) ; B2-B1; B2: baseline of LOGIT(P(AE>=2/3)) ; final estimate (weekly): -4.33
	 50	; THETA14 SLOPE; final estimate (weekly): 20

$OMEGA
	0.1	; ETA1 SLOPE
$EST MAXEVAL=9999 METHOD=1 PRINT=5 LIKE LAPLACE NOABORT MSFO=weekly_prop.msf SIGL=9 NSIG=3
$COV PRINT=E MATRIX=R UNCONDITIONAL
$TABLE STUDY COHORT PTNM ID TIME EVID AMT FRMU BAAG AGE BWT PTS B1 B2 ETA1 P0 P1 P23 Y U449E CE ONEHEADER NOPRINT FILE=weekly_prop.OUT.txt

