% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpdb_access.R
\name{get_prm}
\alias{get_prm}
\title{Access model parameters}
\usage{
get_prm(
  xpdb,
  .problem = NULL,
  .subprob = NULL,
  .method = NULL,
  digits = 4,
  transform = TRUE,
  show_all = FALSE,
  quiet
)
}
\arguments{
\item{xpdb}{An \code{xpose_data} object from which the model output file data will be extracted.}

\item{.problem}{The problem to be used, by default returns the last one for each file.}

\item{.subprob}{The subproblem to be used, by default returns the last one for each file.}

\item{.method}{The estimation method to be used, by default returns the last one for each file}

\item{digits}{The number of significant digits to be displayed.}

\item{transform}{Should diagonal OMEGA and SIGMA elements be transformed to standard deviation and 
off diagonal elements be transformed to correlations.}

\item{show_all}{Logical, whether the 0 fixed off-diagonal elements should be removed from the output.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\value{
A tibble for single problem/subprob or a named list for multiple problem|subprob.
}
\description{
Access model parameter estimates from an xpdb object.
}
\examples{
# Store the parameter table
prm <- get_prm(xpdb_ex_pk, .problem = 1)

# Display parameters to the console
prm_table(xpdb_ex_pk, .problem = 1)

}
\seealso{
\code{\link{prm_table}}
}
