% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_import.R
\name{manual_nm_import}
\alias{manual_nm_import}
\title{Manually define nonmem tables to be imported}
\usage{
manual_nm_import(tab_names = c("sdtab", "mutab", "patab", "catab", "cotab",
  "mytab", "extra", "xptab", "cwtab"), tab_suffix = "", sim_suffix = "sim")
}
\arguments{
\item{tab_names}{Provide the name of the tables to import e.g. 'sdtab', 'patab', 'cotab', 
'catab' for NONMEM.}

\item{tab_suffix}{Default is '', but can be changed to any character string to be used as 
suffix in the table names.}

\item{sim_suffix}{Default is 'sim', but can be changed to any character string to be used as 
suffix in the simulation table names e.g. sdtab001sim.}
}
\description{
Manually provide names of the table files to be imported by \code{xpose_data}.
}
\details{
In order to be imported manually, table names must follow the following convention: 
\code{<tab_names><runno><tab/sim_suffix>} e.g. sdtab001sim. When the argument `file` is used in 
\code{xpose_data}, the \code{<runno>} part is guessed by taking the portion of the string starting 
by any digit and ending at the file extension e.g. \code{file = run001a.mod} will guess <runno> as
`001a`. If no valid <runno> can be guessed, xpose will return an error. In this case it is advised 
to use the \code{xpose_data} argument `runno` directly rather than `file` hence preventing xpose 
from having to guess <runno>.

Note that with manual table import xpose still reads in the NONMEM model file in order to generate
the run summary.
}
\examples{
\dontrun{
# Import all names specified by default as in xpose4
xpose_data(runno = '001', manual_import = manual_nm_import())

# Import a specific table name
xpose_data(runno = '001', manual_import = manual_nm_import(tab_names = 'mytab'))
}
}
\seealso{
\code{\link{xpose_data}}
}
