% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.graph.par.R, R/xpose.write.R
\name{export.graph.par}
\alias{export.graph.par}
\alias{xpose.write}
\title{Exports Xpose graphics settings to a file.}
\usage{
export.graph.par(object)

xpose.write(object, file = "xpose.ini")
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{file}{The file to contain exported Xpose settings.}
}
\value{
Null.
}
\description{
This function exports graphics settings for a specified Xpose data object to
a file.
}
\details{
This function exports the graphics settings (contents of
object@Prefs@Graph.prefs) for a given \code{xpose.data} object to a file,
typically 'xpose.ini'. It is a wrapper for \code{xpose.write}. Note that the
file format is not the same as is used in
\code{\link{import.variable.definitions}} and
\code{\link{export.variable.definitions}}.
}
\section{Functions}{
\itemize{
\item \code{xpose.write}: export graphics settings for a specified Xpose data object to
a file.
}}

\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## For a filename prompt
export.graph.par(xpdb5)

## Command-line driven
xpose.write(xpdb5, "c:/XposeSettings/mytheme.ini")
}

}
\seealso{
\code{\link{import.graph.par}}, \code{\link{xpose.prefs-class}}

Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson & Justin Wilkins
}
\concept{data functions}
\keyword{methods}
