% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absval.iwres.vs.ipred.R
\name{absval.iwres.vs.ipred}
\alias{absval.iwres.vs.ipred}
\title{Absolute individual weighted residuals vs individual predictions for Xpose 4}
\usage{
absval.iwres.vs.ipred(
  object,
  ylb = "|iWRES|",
  type = "p",
  ids = FALSE,
  idsdir = "up",
  smooth = TRUE,
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{type}{Type of plot. The default is points only ("p"), but lines ("l")
and both ("b") are also available.}

\item{ids}{Should id values be displayed?}

\item{idsdir}{Direction for displaying point labels. The default is "up",
since we are displaying absolute values.}

\item{smooth}{Logical value indicating whether an x-y smooth should be
superimposed.  The default is TRUE.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns an xyplot of |IWRES| vs IPRED.
}
\description{
This is a plot of absolute individual weighted residuals (|IWRES|) vs
individual predictions (IPRED), a specific function in Xpose 4. It is a
wrapper encapsulating arguments to the \code{xpose.plot.default} function.
Most of the options take their default values from xpose.data object but may
be overridden by supplying them as arguments.
}
\details{
A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} for details.
}
\examples{

## Here we load the example xpose database 
data(simpraz.xpdb)
xpdb <- simpraz.xpdb

## A vanilla plot
absval.iwres.vs.ipred(xpdb)

## A conditioning plot
absval.iwres.vs.ipred(xpdb, by="HCTZ")

## Custom heading and axis labels
absval.iwres.vs.ipred(xpdb, main="My conditioning plot", ylb="|IWRES|", xlb="IPRED")

## Custom colours and symbols, no IDs
absval.iwres.vs.ipred(xpdb, cex=0.6, pch=3, col=1, ids=FALSE)


}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link{xpose.prefs-class}}, \code{\link{xpose.data-class}},
\code{\link{runsum}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
