% Xpose 4
% An R-based population pharmacokinetic/
% pharmacodynamic model building aid for NONMEM.
% Copyright (C) 1998-2004 E. Niclas Jonsson and Mats Karlsson.
% Copyright (C) 2005-2008 Andrew C. Hooker, Justin J. Wilkins, 
% Mats O. Karlsson and E. Niclas Jonsson.
% Copyright (C) 2009-2010 Andrew C. Hooker, Mats O. Karlsson and 
% E. Niclas Jonsson.

% This file is a part of Xpose 4.
% Xpose 4 is free software; you can redistribute it and/or
% modify it under the terms of the GNU Lesser General Public License
% as published by the Free Software Foundation, either version 3
% of the License, or (at your option) any later version.

% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU Lesser General Public License for more details.

% You should have received a copy of the GNU Lesser General Public License
% along with this program.  A copy can be cound in the R installation
% directory under \share\licenses. If not, see http://www.gnu.org/licenses/.

\name{xpose.plot.default}
\alias{xpose.plot.default}
\title{The Xpose 4 generic functions for continuous y-variables. }
\description{
This function is a wrapper for the lattice xyplot function.
}
\usage{
xpose.plot.default(x,y,object,
           inclZeroWRES = FALSE,
           onlyfirst    = FALSE,
           samp         = NULL,
           panel        = xpose.panel.default,
           groups       = object@Prefs@Xvardef$id,
           ids          = object@Prefs@Graph.prefs$ids,
           logy         = FALSE,
           logx         = FALSE,
           yscale.components= "default",#function(...) yscale.components.default(...),
           xscale.components= "default",#function(...) xscale.components.default(...),

           aspect       = object@Prefs@Graph.prefs$aspect,
           funx         = NULL,
           funy         = NULL,
           iplot        = NULL,

           ## Prediction interval settings
           PI           = NULL,
           
           ## Conditioning settings
           by=object@Prefs@Graph.prefs$condvar,
           force.by.factor = FALSE,
           ordby     = object@Prefs@Graph.prefs$ordby,
           byordfun  = object@Prefs@Graph.prefs$byordfun,
           shingnum  = object@Prefs@Graph.prefs$shingnum,
           shingol   = object@Prefs@Graph.prefs$shingol,
           by.interval   = NULL,
           strip = function(...){
             strip.default(...,strip.names=c(TRUE,TRUE))
           },
           use.xpose.factor.strip.names=TRUE,
           
           ## Subset stuff
           subset       = xsubset(object),

           autocorr=FALSE,
           
           ## Axes and titles
           main         = xpose.create.title(x,y,object,subset,funx,funy,...),
           xlb          = xpose.create.label(x,object,funx,logx,autocorr.x=autocorr,...),
           ylb          = xpose.create.label(y,object,funy,logy,autocorr.y=autocorr,...),
           scales       = list(),           

           ## Superpose smooth
           suline       = object@Prefs@Graph.prefs$suline,

           ## Categorical stuff
           bwhoriz      = object@Prefs@Graph.prefs$bwhoriz,
           
           ## Dilution stuff
           dilution     = FALSE,
           dilfrac      = object@Prefs@Graph.prefs$dilfrac,
           diltype      = object@Prefs@Graph.prefs$diltype,
           dilci        = object@Prefs@Graph.prefs$dilci,
           seed         = NULL,

           mirror       = FALSE,
           max.plots.per.page=4,
           mirror.aspect="fill",
           pass.plot.list=FALSE,
           x.cex=NULL,
           y.cex=NULL,
           main.cex=NULL,
           mirror.internal=list(strip.missing=missing(strip)),
           ...)
}

\arguments{
  \item{x}{A string or a vector of strings with the name(s) of the x-variable(s).}
  \item{y}{A string or a vector of strings with the name(s) of the y-variable(s).}
  \item{object}{An "xpose.data" object.}
  \item{inclZeroWRES}{A logical value indicating whether rows with WRES=0
  should be plotted.}
  \item{onlyfirst}{A logical value indicating whether only the first row
    per individual should be included in the plot. }
  \item{samp}{An integer between 1 and object@Nsim
    (see\code{\link[xpose4data]{xpose.data-class}}) specifying which of the
    simulated data sets to extract from SData.}
  \item{panel}{The name of the panel function to use.}
  \item{groups}{A string with the name of any grouping variable (used as
    the groups argument to \code{panel.xyplot}.}
  \item{ids}{A logical value indicating whether text labels should be
    used as plotting symbols (the variable used for these symbols
    indicated by the \code{idlab} xpose data variable).}
  \item{logy}{Logical value indicating whether the y-axis should be logarithmic.}
  \item{logx}{Logical value indicating whether the x-axis should be logarithmic.}
  \item{yscale.components}{Used to change the way the axis look if
    \code{logy} is used. Can be a user difined function or
    \code{link{xpose.yscale.components.log10}}.  If the axes are not log
    transformed then
    \code{\link[lattice:axis.default]{yscale.components.default}} is used.
  }
  \item{xscale.components}{Used to change the way the axis look if
    \code{logx} is used. Can be a user difined function or
    \code{link{xpose.xscale.components.log10}}.  If the axes are not log
    transformed then
    \code{\link[lattice:axis.default]{xscale.components.default}} is used.
  }
  \item{aspect}{The aspect ratio of the display (see \code{\link[lattice]{xyplot}}).}
  \item{funx}{String with the name of a function to apply to the
    x-variable before plotting, e.g. "abs". }
  \item{funy}{String with the name of a function to apply to the
    y-variable before plotting, e.g. "abs". }
  \item{iplot}{Is this an indvidual plots matrix? Internal use only.}
  \item{PI}{Either "lines", "area" or "both" specifying whether
    prediction intervals (as lines, as a shaded area or both) 
    should be computed from the data in \code{SData} and added to the
    display. \code{NULL} means no prediction interval.}
  \item{by}{A string or a vector of strings with the name(s) of the
    conditioning variables.}
  \item{force.by.factor}{Logical value. If TRUE, and \code{by} is not \code{NULL},
    the variable specified by \code{by} is taken as categorical.}
  \item{ordby}{A string with the name of a variable to be used to
    reorder any factor conditioning variables (\code{by}). The variable
    is used in a call to the \code{reorder.factor} function. }
  \item{byordfun}{The name of the function to be used when reordering a
    factor conditioning variable (see argument \code{ordby})}
  \item{shingnum}{The number of shingles ("parts") a continuous
    conditioning variable should be divided into.}
  \item{shingol}{The amount of overlap between adjacent shingles (see
    argument \code{shingnum}) }
  \item{by.interval}{The intervals to use for conditioning on a
    continuous variable with \code{by}.}
  \item{strip}{The name of the function to be used as the strip argument
    to the \code{\link[lattice]{xyplot}}. An easy way to change the strip
    appearance is to use \code{\link[lattice]{strip.custom}}.  For
    example, if you want to change the text in the strips you can use
    \code{strip=strip.custom(factor.levels=c("Hi","There"))} if the
    \code{by} variable is a factor and
    \code{strip=strip.custom(var.name=c("New Name"))} if the
    \code{by} variable is continuous.}
  %\item{par.strip.text}{A list of graphical parameters used to control
  %  the apparence of the text in the strips. See
  %  \code{\link[lattice]{strip.default}}.}
  \item{use.xpose.factor.strip.names}{Use factor names in strips of
    conditioning plots..}
  \item{main}{A string giving the plot title or \code{NULL} if none.}
  \item{xlb}{A string giving the label for the x-axis. \code{NULL} if none.}
  \item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}
  \item{subset}{A string giving the subset expression to be applied to
    the data before plotting. See \code{\link[xpose4data]{xsubset}}.}
  \item{autocorr}{Is this an autocorrelation plot?  Values can be
    \code{TRUE/FALSE}.}
  \item{scales}{A list to be used for the \code{scales} argument in
    \code{\link[lattice]{xyplot}}.}
  \item{suline}{A string giving the variable to be used to construct a
    smooth to superpose on the display. \code{NULL} if none. This
    argument is used if you want to add a superpose line of a variable
    not present in the \code{y} list of variables.}
  \item{bwhoriz}{A logical value indicating if box and whiskers bars
    should be plotted horizontally or not. Used when the x-variable(s)
    is categorical.}
  \item{dilution}{Logical value indicating whether data dilution should
    be used.}
  \item{diltype}{Indicating what type of dilution to apply. \code{NULL}
    means random dilution without stratification. A non\code{NULL} value
    means stratified dilution.}
  \item{dilfrac}{Dilution fraction indicating the expected fraction of
    individuals to display in the plots. The exact meaning depends on
    the type of dilution (see below).}
  \item{dilci}{A number between 0 and 1 giving the range elegible for
    dilution in a stratified dilution (see below). }
  \item{seed}{Seed number used for random dilution. \code{NULL} means no
    seed.}
  \item{mirror}{Should we create mirror plots from simulation data?
    Value can be \code{FALSE}, \code{TRUE} or \code{1} for one mirror
    plot, or \code{3} for three mirror plots.}
  \item{max.plots.per.page}{The maximum number of plots per page that
    can be created with the mirror plots.}
  \item{mirror.aspect}{The aspect ratio of the plots used for mirror
    functionality.}
  \item{pass.plot.list}{Should we pass the list of plots created with
    mirror or should we print them directly.  Values can be
    \code{TRUE/FALSE}.}
  \item{x.cex}{The size of the x-axis label.}
  \item{y.cex}{The size of the y-axis label.}
  \item{main.cex}{The size of the title.}
  \item{mirror.internal}{an internal mirror argument used in
    \code{\link[xpose4generic]{create.mirror}}.  Checks if the
    \code{strip} argument from \code{\link[lattice]{xyplot}} has been used.}
  \item{\dots}{Other arguments passed to
    \code{\link[xpose4generic]{xpose.panel.default}}.}
}
\details{
  \code{y} must be numeric (continuous) while \code{x} can be
  either numeric of factor. If \code{x} is numeric then a regular
  xy-plot is drawn. If x is a factor, on the other hand, a box and
  whiskers plot is constructed.
  
  \code{x} and \code{y} can be either single valued strings or vector of
  strings. \code{x} and \code{y} can not both be vectors inthe same call
  to the function.

  If \code{ids} is \code{TRUE}, text labels are added to the plotting
  symbols. The labels are taken from the \code{idlab} xpose data
  variable. The way the text labels are plotted is governed by the
  \code{idsmode} argument (passed down to the panel
  function). \code{idsmode=NULL} (the default) means that only extreme
  data points are labelled while a non-\code{NULL} value adds labels to
  all data points (the default in Xpose 3). \code{xpose.panel.default}
  identifies extreme data points by fitting a loess smooth (\code{y~x})
  and looking at the residuals from that fit. Points that are associated
  with the highest/lowest residuals are labelled. "High" and "low" are
  judged by the panel function parameter \code{idsext}, which gives the
  fraction of the total number of data points that are to be judged
  extreme in the "up" and "down" direction. The default value for
  \code{idsext} is 0.05 (see \code{\link[xpose4data]{xpose.prefs-class}}). There is
  also a possibility to label only the high or low extreme points. This
  is done through the \code{idsdir} argument to
  \code{xpose.panel.default}. A value of "both" (the default) means that
  both high and low extreme points are labelled while "up" and "down"
  labels the high and low extreme points respectively.

  Data dilution is useful is situations when there is an excessive
  amount of data. \code{xpose.plot.default} can dilute data in two
  different ways. The first is a completely random dilution in which all
  individuals are elegible of exclusion from the plot. In this case the
  argument \code{dilfrac} determines the fraction of individuals that
  are excluded from the plot. The second type of dilution uses
  stratification to make sure that none of the extreme individuals are
  omitted from the plot. Extreme individuals are identified in a similar
  manner as extreme data points are identified for text labelling. A
  smooth is fitted to the data and the extreme residuals from that fit
  is used to inform about extremeness. What is judged as extreme is
  determined by the argument \code{dilci}, which defaults to 0.95 (Note
  that the meaning of this is the opposite to
  \code{idsext}). \code{dilci} give the confidence level of the interval
  around the fitted curve outside of which points are deemed to be
  extreme. Extreme individuals are those that have at least one point in
  the "extremeness" interval. Individuals that do not have any extreme
  points are elegible for dilution and \code{dilfrac} give the number of
  these that should be omitted from the graph. This means that
  \code{dilfrac} should usually be grater for stratified dilution than in
  completely random dilution. Any smooths added to a diluted plot is
  based on undiluted data.
  
  More graphical parameters may be passed to \code{\link[xpose4generic]{xpose.panel.default}}. 
}
\value{
  Returns a xyplot graph object.
}
\author{E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins}
\seealso{
  \code{\link[xpose4generic]{xpose.panel.default}},
  \code{\link[lattice]{xyplot}},
  \code{\link[lattice]{panel.xyplot}},
  \code{\link[xpose4data]{xpose.prefs-class}},
  \code{\link[xpose4data]{xpose.data-class}}
}
\examples{
\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## A spaghetti plot of DV vs TIME
xpose.plot.default("TIME", "DV", xpdb5) 

## A conditioning plot
xpose.plot.default("TIME", "DV", xpdb5, by = "SEX")
 
## Multiple x-variables
xpose.plot.default(c("WT", "SEX"), "CL", xpdb5)

## Multiple y-variables
xpose.plot.default("WT", c("CL", "V"), xpdb5)
xpose.plot.default("WT", c("CL", "V"), xpdb5, by=c("SEX", "HCTZ"))

## determining the interval for the conditioning variable
wt.ints <- matrix(c(50,60,60,70,70,80,80,90,90,100,100,150),nrow=6,ncol=2,byrow=T)
xpose.plot.default("TIME","DV",xpdb5,by="WT", by.interval=wt.ints)
}

}
\keyword{methods}
