% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimate.theta.mle}
\alias{estimate.theta.eap}
\alias{estimate.theta.map}
\alias{estimate.theta.mle}
\title{Estimation of Ability Parameters}
\usage{
estimate.theta.mle(u, a, b, c, init = NULL, iteration = 15, delta = 0.005,
  bound = 3.5)

estimate.theta.map(u, a, b, c, init = NULL, prior.mu = 0, prior.sig = 1,
  iteration = 15, delta = 0.005, bound = 3.5)

estimate.theta.eap(u, a, b, c)
}
\arguments{
\item{u}{a response matrix, with people in rows and items in columns}

\item{a}{a vector of item discrimination parameters}

\item{b}{a vector of item difficulty parameters}

\item{c}{a vector of item pseudo-guesing parameters}

\item{init}{a vectoro of initial value for theta parmaeters}

\item{iteration}{the maximum iterations of Newton-Raphson procedure}

\item{delta}{convergence criterion used to terminate Newton-Raphson procedure}

\item{bound}{the maximum absolute values of estimated theta parameters}

\item{prior.mu}{the mean of the prior theta distribuiton}

\item{prior.sig}{the standard deviation of the prior theta distribution}
}
\value{
a vector of estimated thetas
}
\description{
\code{estimate.theta.mle} estimates thetas with known item parameters using maximum likelihood.

\code{estimate.theta.map} estimates thetas with known item parameters using maximum a posterior.

\code{estimate.theta.eap} estimates thetas with known item parameters using expected a posterior.
}
\details{
For the maximum likelihood estimation, refer to Baker and Kim (2004), pp. 66-69.

For the maximum a posteriori estimation, refer to Baker and Kim (2004), pp. 192.

For the expected a posteriori, refer to Baker and Kim (2004), pp. 193.
}
\examples{
# MLE
x <- gen.rsp(gen.irt(100, 20))
y <- estimate.theta.mle(x$rsp, x$items$a, x$items$b, x$items$c)
cor(x$thetas, y)
plot(x$thetas, y, xlim=c(-4, 4), ylim=c(-4, 4), col=rgb(.8,.2,.2,.5), pch=16)
abline(a=0, b=1)
# MAP
x <- gen.rsp(gen.irt(100, 20))
y <- estimate.theta.map(x$rsp, x$items$a, x$items$b, x$items$c)
cor(x$thetas, y)
plot(x$thetas, y, xlim=c(-3, 3), ylim=c(-3, 3), col=rgb(.8,.2,.2,.5), pch=16)
abline(a=0, b=1)
# EAP
x <- gen.rsp(gen.irt(100, 20))
y <- estimate.theta.eap(x$rsp, x$items$a, x$items$b, x$items$c)
cor(x$thetas, y)
plot(x$thetas, y, xlim=c(-3, 3), ylim=c(-3, 3), col=rgb(.8,.2,.2,.5), pch=16)
abline(a=0, b=1)
}
\seealso{
Other estimation: \code{\link{estimate.item.jmle}}

Other estimation: \code{\link{estimate.item.jmle}}

Other estimation: \code{\link{estimate.item.jmle}}
}

