% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons.R
\name{prob}
\alias{info}
\alias{likelihood}
\alias{prob}
\title{Common Computations}
\usage{
prob(x, summary = NULL, fun = NULL)

info(x, summary = NULL, fun = NULL)

likelihood(x, summary = NULL, fun = NULL, log = FALSE)
}
\arguments{
\item{x}{an IRT object}

\item{summary}{the direction of summarizing results: 1 by row (over items) and 2 by column (over people)}

\item{fun}{the summarizing function}

\item{log}{TRUE to take logarithm of results}
}
\value{
a matrix or vector (when summarized) results
}
\description{
\code{prob} computes probability for a gve IRT object.

\code{info} computes information for a gve IRT object.

\code{likelihood} computes likelihood for a gve IRT object.
}
\examples{
# probabilities
prob(gen.irt(10, 5))
# product of probabilities
prob(gen.irt(10, 5), summary=1, fun=prod)
# information
info(gen.irt(10, 5)) 
# add information over items
info(gen.irt(10, 5), summary=1, fun=sum) 
# add information over people
info(gen.irt(10, 5), summary=2, fun=sum)
# likelihood of response vectors
likelihood(gen.rsp(gen.irt(10, 5)), summary=1, fun=prod)
# log-likelihood of response vectors
likelihood(gen.rsp(gen.irt(10, 5)), summary=1, fun=sum, log=TRUE)
}
\seealso{
Other commons: \code{\link{gen.irt}}, \code{\link{irt}}

Other commons: \code{\link{gen.irt}}, \code{\link{irt}}

Other commons: \code{\link{gen.irt}}, \code{\link{irt}}
}

