% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_irt_utils.R
\name{irt_select}
\alias{irt_sample}
\alias{irt_select}
\title{Subset IRT Model}
\usage{
irt_select(x, people.index = NULL, items.index = NULL)

irt_sample(x, n.people = NULL, n.items = NULL)
}
\arguments{
\item{x}{an IRT model object}

\item{people.index}{the indices of people to keep}

\item{items.index}{the indices of items to keep}

\item{n.people}{the nubmer of people to sample}

\item{n.items}{the number of items to sample}
}
\description{
Subset and sample from an IRT model object
}
\examples{
# subset
x <- irt_model("3pl")$gendata(10, 5)
irt_select(x, people.index=c(1,3,5))
irt_select(x, items.index=c(1,3,5))
# sample wihtout replacement
irt_sample(x, n.people=3)
irt_sample(x, n.items=3)
# sample with replacement
irt_sample(x, n.people=30)
irt_sample(x, n.items=30)
}

