% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{currency_converter}
\alias{currency_converter}
\title{Currency converter}
\usage{
currency_converter(
  from = "EUR",
  to = "USD",
  start = NULL,
  end = NULL,
  period = "ytd",
  interval = "1d"
)
}
\arguments{
\item{from}{Currency to convert from.}

\item{to}{Currency to convert to.}

\item{start}{Specific starting date. \code{String} or \code{date} object in \code{yyyy-mm-dd} format.}

\item{end}{Specific ending date. \code{String} or \code{date} object in \code{yyyy-mm-dd} format.}

\item{period}{Length of time. Defaults to \code{'ytd'} Valid values are:
\itemize{
\item \code{'1d'}
\item \code{'5d'}
\item \code{'1mo'}
\item \code{'3mo'}
\item \code{'6mo'}
\item \code{'1y'}
\item \code{'2y'}
\item \code{'5y'}
\item \code{'10y'}
\item \code{'ytd'}
\item \code{'max'}
}}

\item{interval}{Time between data points. Defaults to \code{'1d'} Valid values are:
\itemize{
\item \code{'1h'}
\item \code{'1d'}
\item \code{'5d'}
\item \code{'1wk'}
\item \code{'1mo'}
\item \code{'3mo'}
}}
}
\value{
A \code{data.frame}.
}
\description{
Retrieve current conversion rate between two currencies as well as historical rates.
}
\examples{
\donttest{
currency_converter('GBP', 'USD', '2022-07-01', '2022-07-10')
currency_converter('GBP', 'USD', period = '1mo', interval = '1d')
}

}
