context("Crossplatform")	


test_that("KMeans trains as expected on synthetical dataset", {
	# generate synthetic data set (see some stack overflow question)
	
	skip ("Crossplatform turned off because of floating point differences.")
	
	set.seed(101)
	k <- 8
	x <- matrix(rnorm(25000, mean=0.5, sd=1), ncol=5)
	#print(sum(x))
	E = yakmoR::orthoKMeansTrain (x = x, k = 8, rounds = 4, verbose = FALSE)

#	dump("E", "/tmp/A")
	
	centers1 = c(-0.773127221855639, 0.659700086388155, 0.329083376361123, 
    1.49625118777897, 0.873625000244238, -0.117523595254004, 
    1.11701279111456, 0.691882139142175, 0.523512940088078, 0.873967587176912, 
    -0.715550325210234, 0.961049187355381, 0.0590962848584614, 
    0.974772887297086, 0.102283762787814, 1.40187560175312, 0.514551753981911, 
    0.620528362142422, 0.0693927741188999, -0.365472127398107, 
    -0.450799384905508, 1.02898582722943, 1.68835444089093, 0.589286018013158, 
    0.195040796864759, 1.67387081498579, 0.44803991200936, 0.941416385472268, 
    0.0169186260829311, 1.14415353001268, 0.280135613335892, 
    -0.627756581985967, 1.05873417708419, 1.35937738140248, -0.293514189008916, 
    -0.00415706495722405, 1.43761247472097, -0.524762797420651, 
    0.758238978423363, 0.154921316330257)
        
	expect_equal (array(E$centers[[1]]), array(centers1))

	
	centers4 = c(-0.0776147700819189, -0.0499046687303483, 
    -0.215404046453374, -0.00667203376210142, 0.233411354382311, 
    -0.402647305828248, 0.133614604412649, 0.474263412297043, 
    0.170108272371882, -0.174293526192245, -0.147520896054915, 
    0.101014358676703, 0.225339341580646, -0.0765289765231493, 
    -0.471401435674393, 0.050109464594559, -0.130567246766113, 
    -0.204144929247889, 0.536968355845358, 0.11299143112888, 
    -0.225042135109889, -0.104673765459266, 0.0130436284488291, 
    0.0668465098157933, -0.0169348091808531, -0.263611928589394, 
    -0.213448502583153, 0.0301201709903281, 0.352976237312932, 
    0.273776163592804, 0.175893532169879, -0.243161100810772, 
    -0.43637416385574, 0.187181370697184, 0.115525384075672, 
    0.0421309952692461, 0.152787425309201, 0.0714655385683078, 
    -0.0173808095309812, -0.0562325221799175)
    
	expect_equal (array(E$centers[[4]]), array(centers4))
	
	
	# m = 1
	clusterhead =	 	c(4, 3, 0, 1, 5, 6, 7, 2, 4, 2, 6, 7, 6, 0, 5, 1, 4, 2, 3)
	clustertail = 		c(7, 1, 1, 0, 3, 7, 3, 3, 1, 6, 1, 0, 0, 2, 1, 1, 2, 7, 0)
	
 	expect_equal (E$cluster[[1]][1:19], clusterhead )
 	expect_equal (E$cluster[[1]][4982:5000], clustertail)

 	# m = 4
	clusterhead = 	c(4, 5, 3, 2, 4, 7, 6, 3, 6, 5, 4, 2, 4, 5, 3, 3, 1, 7, 0)
	clustertail = 		c(3, 6, 2, 7, 3, 0, 6, 3, 0, 6, 0, 5, 2, 5, 1, 4, 5, 0, 3)

	
 	expect_equal (E$cluster[[4]][1:19], clusterhead )
 	expect_equal (E$cluster[[4]][4982:5000], clustertail)

	# check the returned objective values
	expect_equal (E$obj[1], 13445.5881051911)


	# test that it works with allmodels 
	E = yakmoR::orthoKMeansTrain(x, k = k, rounds = 2, verbose = FALSE)
	
#	dump("E", "/tmp/B")


	centers1 = c(0.457783208292489, 
    0.949349468453526, -0.262996151136616, 1.29960680695247, 
    -0.143549461941704, -0.0850906335622183, 1.6138271980909, 
    0.135461948184516, 0.388490420525025, -0.726870078373594, 
    0.159287182279319, 1.27860575725262, 1.78213299602382, 0.585871890538607, 
    0.588179774322983, 0.0757016265107878, 0.593448575645403, 
    -0.166887200954954, 0.0123178445555395, -0.474434496209413, 
    0.983285354557091, 0.365491686999431, 1.41005296935295, 1.40112792406255, 
    1.71118749911209, 0.455821311782323, -0.248245565629291, 
    0.203774257807414, 0.379108777009129, 1.28239643181955, 0.449802402144272, 
    -0.282836050656249, 1.39810161274261, 0.138204277407768, 
    1.3681228090571, 0.326784275623653, 0.67656718270126, -0.600775471710532, 
    0.735903858462851, -0.107117341604191)
	
	expect_equal (array(E$centers[[1]]), array(centers1))

	
	centers2 =  c(0.270132868893908, 0.661003770459709, 0.404797354170865, 
        -0.218530694781161, -0.929685007465012, -0.626265719852613, 
        0.0874722925134514, 0.175553777250337, -0.600489337915517, 
        0.49396506946141, 0.211188769031093, 0.00518280758181702, 
        -0.482012079210731, 0.598315240505812, -0.0723005158484064, 
        -0.0786701135065079, 0.541029369367823, -0.206991674149549, 
        0.0315175354591124, -0.894569294608316, 0.439178319121343, 
        -0.00440240713112187, 0.215692156471382, -0.180472554783757, 
        0.050385966614085, 0.0748682459817721, -0.947092137315122, 
        0.478140168395583, 0.441645850696534, -0.160605343183138, 
        0.656697163277169, -0.639272520791285, 0.168162676805103, 
        -0.022347695761581, -0.612303311991919, 0.26335997733688, 
        0.24643743719042, -0.106292232012246, -0.884748670382391, 
        0.884639156906461)     
	expect_equal (array(E$centers[[2]]), array(centers2))
	

	
	# just a quick check on a few entires
	clusterhead = 	c(3, 5, 7, 4, 5, 7, 3, 1, 3, 5, 6, 4, 6, 7, 5, 3, 2, 5, 5)
	clustertail =     	c(4, 0, 0, 4, 3, 3, 6, 3, 0, 1, 0, 0, 4, 5, 0, 0, 7, 7, 2)
	expect_equal (E$cluster[[1]][1:19], clusterhead)
 	expect_equal (E$cluster[[1]][4982:5000], clustertail)

 	
	# just a quick check on a few entires
	clusterhead = 	c(3, 1, 7, 7, 0, 6, 7, 4, 0, 0, 6, 5, 1, 4, 0, 4, 3, 0, 3)
	clustertail = 		c(7, 1, 4, 5, 6, 2, 1, 6, 6, 0, 6, 4, 5, 6, 0, 1, 4, 2, 1)
 	expect_equal (E$cluster[[2]][1:19], clusterhead)
 	expect_equal (E$cluster[[2]][4982:5000], clustertail)

 	
	# check the returned objective values
	expect_equal (E$obj[1], 13509.4644135544)
	expect_equal (E$obj[2], 5968.61537980463)

	
})


test_that("KMeans predicts as expected on synthetical dataset", {
	# generate synthetic data set (see stack overflow question)

	skip ("Crossplatform turned off because of floating point differences.")

	# train first
	set.seed(101)
	k <- 8
	x <- matrix(rnorm(25000, mean=0.5, sd=1), ncol=5)
	obj = yakmoR::orthoKMeansTrain (x = x, k = 8, rounds = 4, verbose = FALSE)

	
	# check predictions for all rounds are done
	# get true output by 
	set.seed(100)
	x <- matrix(rnorm(25000, mean=0.5, sd=1), ncol=5)
	E = yakmoR::orthoKMeansPredict (x = x, obj = obj, verbose = FALSE)
	
# 	for (i in 1:4) {
# 		u = E$cluster[1:19,i]
# 		dump(c("u"), file = "/tmp/C", append = TRUE)
# 		t = E$cluster[4982:5000,i]
# 		dump(c("t"), file = "/tmp/C", append =  TRUE)
# 	}
		
	# just a quick check on a few entires
	clusterhead1 = 	c(7, 4, 7, 3, 2, 1, 1, 6, 0, 7, 6, 6, 5, 2, 4, 1, 1, 7, 2)
	clustertail1 = 		c(3, 6, 3, 1, 1, 2, 1, 3, 0, 7, 5, 5, 6, 4, 2, 0, 3, 7, 1)
	expect_equal (E$cluster[1:19,1], clusterhead1)
 	expect_equal (E$cluster[4982:5000,1], clustertail1)

	clusterhead2 = c(1, 6, 0, 5, 0, 5, 2, 3, 6, 1, 4, 5, 5, 3, 2, 1, 4, 6, 7)
	clustertail2 = c(0, 2, 3, 1, 6, 0, 7, 4, 1, 1, 5, 1, 5, 3, 1, 5, 5, 7, 7)
	expect_equal (E$cluster[1:19,2], clusterhead2)
 	expect_equal (E$cluster[4982:5000,2], clustertail2)

	clusterhead3 = c(5, 2, 0, 7, 7, 7, 6, 2, 2, 5, 2, 4, 3, 7, 7, 2, 1, 6, 3)
	clustertail3 = c(6, 5, 7, 4, 2, 0, 1, 4, 0, 3, 0, 7, 6, 6, 3, 1, 0, 6, 1)
	expect_equal (E$cluster[1:19,3], clusterhead3)
 	expect_equal (E$cluster[4982:5000,3], clustertail3)
	
	clusterhead4 = c(3, 2, 3, 3, 3, 2, 0, 1, 7, 3, 2, 1, 0, 3, 6, 7, 2, 4, 1)
	clustertail4 = c(1, 2, 1, 6, 7, 0, 2, 4, 3, 5, 4, 3, 0, 0, 7, 7, 1, 7, 2)
	expect_equal (E$cluster[1:19,4], clusterhead4)
 	expect_equal (E$cluster[4982:5000,4], clustertail4)
	
})


