% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{print.yamlet}
\alias{print.yamlet}
\title{Print a Yamlet}
\usage{
\method{print}{yamlet}(x, ..., simplify = getOption("yamlet_print_simplify", TRUE))
}
\arguments{
\item{x}{yamlet}

\item{...}{ignored}

\item{simplify}{whether to collapse the display of very simple lists into one line of output}
}
\value{
invisible(x)
}
\description{
Prints a yamlet object for interactive inspection.
By default, lists with no names (recursively) that
unlist to identical length are displayed in one 
line for compactness.  If this seems misleading,
you can turn it of with \code{options(yamlet_print_simplify = FALSE)}.
}
\examples{
as_yamlet('mpg: [efficiency, mi/gallon]\nvs: [Engine, [V-shaped: 0, straight: 1]]')
}
\seealso{
Other yamlet: 
\code{\link{[.yamlet}()},
\code{\link{as.character.yamlet}()},
\code{\link{as_yamlet.character}()},
\code{\link{as_yamlet.data.frame}()},
\code{\link{as_yamlet.list}()},
\code{\link{as_yamlet.yamlet}()},
\code{\link{as_yamlet.yam}()},
\code{\link{as_yamlet}()}
}
\concept{yamlet}
\keyword{internal}
