% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.frame.R
\name{as.data.frame.yamlet}
\alias{as.data.frame.yamlet}
\title{Coerce Yamlet to Data Frame}
\usage{
\method{as.data.frame}{yamlet}(
  x,
  row.names = "item",
  optional = FALSE,
  sep = "\\n",
  def = ": ",
  ...
)
}
\arguments{
\item{x}{yamlet; see \code{\link{decorations}} and \code{\link{read_yamlet}}}

\item{row.names}{a name for a column to hold top-level names, or NULL to represent these as row.names}

\item{optional}{if TRUE and row.names is NULL, row.names will not be set}

\item{sep}{separator for multiple items within an attribute}

\item{def}{definition string: separator between items and their (preceding) names, if any}

\item{...}{ignored}
}
\value{
data.frame
}
\description{
Coerces yamlet to data.frame. Columns are constructed in the order that
attributes are encountered, beginning with top-level 'item' (default).
Cell contents are calculated using
\code{getOption('yamlet_cell_value', yamlet::cell_value)} to which
is passed the cell-specific metadata as well as \code{sep} and \code{def}.
}
\examples{

library(magrittr)

file <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
file \%>\% read_yamlet \%>\% explicit_guide \%>\% as.data.frame
file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')

# phenobarb.yaml has conditional metadata that benefits
# from interpretation in the context of the data itself.
# thus, we
# * read the whole 'decorated' object (not just yaml),
# * resolve the 'guide' ambiguity,
# extract the best-guess decorations, and
# convert to data.frame.

file \%>\% io_csv \%>\% resolve \%>\% decorations \%>\% as.data.frame

}
\keyword{internal}
