% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{classified.default}
\alias{classified.default}
\alias{classified}
\title{Create Classified by Default}
\usage{
\method{classified}{default}(
  x = character(),
  levels,
  labels,
  exclude = NA,
  ordered = is.ordered(x),
  nmax = NA,
  token = character(0),
  ...
)
}
\arguments{
\item{x}{see \code{\link{factor}}}

\item{levels}{see \code{\link{factor}}}

\item{labels}{see \code{\link{factor}}, must have same length as levels}

\item{exclude}{see \code{\link{factor}}}

\item{ordered}{see \code{\link{factor}}}

\item{nmax}{see \code{\link{factor}}}

\item{token}{informative label for messages}

\item{...}{ignored}
}
\value{
'classified' 'factor'
}
\description{
Creates a factor of subclass 'classified',
for which there are attribute-preserving methods.
In particular, classified has a codelist attribute
indicating the origin of its levels: it is
constructed from the codelist attribute of x
if available, or from 'levels' and 'labels'
by default. Unlike the case for \code{\link{factor}},
length of labels cannot be one (i.e., different from
length of levels).
}
\examples{

# classified creates a factor with a corresponding codelist attribute
classified(c('a','b','c'))

# codelist 'remembers' the origins of levels
classified(c('a','b','c'), labels = c('A','B','C'))

# classified is 'reversible'
library(magrittr)
c('a','b','c') \%>\%
  classified(labels = c('A','B','C')) \%>\%
  unclassified
}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.dvec}()},
\code{\link{classified.factor}()},
\code{\link{classified_generic}},
\code{\link{desolve.classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
