% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate.character}
\alias{decorate.character}
\title{Decorate Character}
\usage{
\method{decorate}{character}(x, meta = NULL,
  coerce = getOption("coerce", FALSE), ...)
}
\arguments{
\item{x}{file path for csv}

\item{meta}{file path for corresponding yaml metadata, or a yamlet}

\item{coerce}{whether to coerce to factor where guide is a list}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Treats \code{x} as a csv file path. By default,
metadata is sought from a file with the same
base but the 'yaml' extension.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','yamlet.csv')
meta <- system.file(package = 'yamlet', 'extdata','yamlet.yaml')
x <- decorate(file)
x <- decorate(file, coerce = TRUE)
x <- decorate(file, meta = meta)
sapply(x, attr, 'label')

}
\seealso{
Other decorate: \code{\link{decorate.data.frame}},
  \code{\link{decorate.list}}, \code{\link{decorate}},
  \code{\link{decorations.data.frame}},
  \code{\link{decorations}}
}
\concept{decorate}
