% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate.list}
\alias{decorate.list}
\title{Decorate List}
\usage{
\method{decorate}{list}(x, meta = NULL, coerce = getOption("coerce",
  FALSE), ...)
}
\arguments{
\item{x}{object inheriting from \code{list}}

\item{meta}{file path for corresponding yaml metadata, or a yamlet; an attempt will be made to guess the file path if x has a 'source' attribute}

\item{coerce}{whether to coerce to factor where guide is a list}

\item{...}{passed arguments}
}
\value{
list, possibly with member attributes
}
\description{
Decorates a list-like object. Expects metadata with labels and guides,
where guides are units, factor levels and labels (codes, decodes), or
datetime formatting strings. For guides that are lists, the corresponding
data element may optionally be coerced to factor.
}
\examples{
example(decorate.data.frame)

}
\seealso{
Other decorate: \code{\link{decorate.character}},
  \code{\link{decorate.data.frame}},
  \code{\link{decorate}},
  \code{\link{decorations.data.frame}},
  \code{\link{decorations}}
}
\concept{decorate}
