% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{print.ag}
\alias{print.ag}
\title{Print Automatic Labels and Units for ggplot}
\usage{
\method{print}{ag}(x, labeller = getOption("labeller", default = as_lab),
  ...)
}
\arguments{
\item{x}{class 'ag' from \code{\link{agplot}}}

\item{labeller}{a function (or its name) like \code{\link{as_lab}} to generate axis labels}

\item{...}{passed arguments}
}
\value{
used for side effects
}
\description{
Prints automatic labels and units for ggplot.
Reworks the labels as a function of attributes
in corresponding data. \code{labeller} will
receive existing labels one at a time
and corresponding attributes(if any) from data.
}
\examples{
meta <- system.file(package = 'yamlet', 'extdata','yamlet.csv')
x <- decorate(meta)
library(ggplot2)
agplot(data = x) + geom_path(aes(x = TIME, y = DV))
agplot(data = x, aes(x = TIME, y = DV)) + geom_path()
agplot(data = x) + geom_path(aes(x = TIME, y = DV)) + xlab('the time (hours)')
options(enclose = c('[',']'))
agplot(data = x) + geom_path(aes(x = TIME, y = DV))
}
\seealso{
Other lab: \code{\link{agplot}}, \code{\link{as_lab.list}},
  \code{\link{as_lab}}
}
\concept{lab}
