% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agplot.R
\name{agplot}
\alias{agplot}
\title{Request Automatic Labels and Units for ggplot}
\usage{
agplot(data, ...)
}
\arguments{
\item{data}{data.frame or similar}

\item{...}{passed to \code{\link[ggplot2]{ggplot}}}
}
\value{
return value like \code{\link[ggplot2]{ggplot}}
}
\description{
Requests automatic labels and units for ggplot.
Simply subclasses the output of ggplot, in
expectation of associated print method \code{\link{print.ag}}.
}
\examples{
meta <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(meta)
library(ggplot2)
class(agplot(data = x) + geom_path(aes(x = time, y = conc)))
class(agplot(data = x, aes(x = time, y = conc)) + geom_path())
example(print.ag)
}
\seealso{
Other lab: 
\code{\link{as_lab.list}()},
\code{\link{as_lab}()},
\code{\link{print.ag}()},
\code{\link{singularity}()}
}
\concept{lab}
