% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorations.data.frame}
\alias{decorations.data.frame}
\title{Retrieve Decorations for Data Frame}
\usage{
\method{decorations}{data.frame}(x,
  coerce = getOption("yamlet_coerce_decorations", FALSE),
  exclude_attr = getOption("yamlet_exclude_attr", "class"), ...)
}
\arguments{
\item{x}{data.frame}

\item{coerce}{logical: whether to coerce factor levels to guide; alternatively, a key for the levels}

\item{exclude_attr}{attributes to remove from the result}

\item{...}{ignored}
}
\value{
named list
}
\description{
Retrieve the decorations of a data.frame; i.e., the metadata
used to decorate it. Returns a list with same names as the data.frame.
By default, \code{class} attributes are excluded from the result,
as this is an attribute you likely don't want to manipulate independently.
Consider carefully whether the default handling of factor levels
(see \code{coerce} argument) is appropriate for your application.
}
\examples{
library(csv)
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(as.csv(file))[,c('conc','Race')]
y <- decorate(as.csv(file))[,c('conc','Race')] \%>\% resolve
decorations(x)
decorations(y)
decorations(y, coerce = TRUE)
decorations(y, coerce = 'codelist')
decorations(y, exclude_attr = NULL)
}
\seealso{
Other decorate: \code{\link{decorate.character}},
  \code{\link{decorate.data.frame}},
  \code{\link{decorate.list}}, \code{\link{decorate}},
  \code{\link{decorations}}
}
\concept{decorate}
