% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{unnest}
\alias{unnest}
\title{Collapse Uninformative Levels}
\usage{
unnest(x, ...)
}
\arguments{
\item{x}{object}
}
\value{
named list
}
\description{
Each element of a list that is itself a list
and does not have a name but has exactly one element
that DOES have a name should become that element
and have that name (recursively, from depth).
Collapses uninformative levels of nested lists.
}
\examples{

# yaml.load reads this as a list of two un-named lists whose elements are named.
str(yaml::yaml.load('[foo: 1, bar: 3]'))

# yamlet treats it as a list of two named integers.
str(unnest(yaml::yaml.load('[foo: 1, bar: 3]')))
}
\seealso{
Other unnest: \code{\link{unnest.default}},
  \code{\link{unnest.list}}
}
\concept{unnest}
\keyword{internal}
