% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{ggplot.decorated}
\alias{ggplot.decorated}
\title{Create a New ggplot for a Decorated Data Frame}
\usage{
\method{ggplot}{decorated}(data, ...)
}
\arguments{
\item{data}{decorated, see \code{\link{decorate}}}

\item{...}{passed to \code{\link[ggplot2]{ggplot}}}
}
\value{
return value like \code{\link[ggplot2]{ggplot}} but inheriting 'decorated_ggplot'
}
\description{
Creates a new ggplot object for a decorated data.frame.
This is the ggplot() method for class 'decorated'.
It creates a ggplot object using the default method,
but reclassifies it as 'decorated_ggplot' so that a custom print method
is invoked; see \code{\link{print.decorated_ggplot}}.
}
\details{
This approach is similar to but more flexible than
the method for \code{\link{ggready}}. Currently,
there is only one method for resolve() (\code{\link{resolve.decorated}})
with the result that all 'resolved' objects inherit 'decorated'
and thus can use \code{\link{ggplot.decorated}}.

For finer control, you can switch between 'data.frame'
and to 'decorated' using \code{\link{as_decorated}}
(supplies null decorations) and \code{\link{as.data.frame}}
(preserves decorations).
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
library(ggplot2)
library(dplyr)
library(magrittr)
# par(ask = FALSE)

x <- decorate(file)
x \%<>\% filter(!is.na(conc))

# Manipulate class to switch among ggplot methods.
class(x)
class(data.frame(x))
class(as_decorated(data.frame(x)))

# The bare data.frame gives boring labels and unordered groups.
map <- aes(x = time, y = conc, color = Heart)
data.frame(x) \%>\% ggplot(map) + geom_point()

# Decorated data.frame uses supplied labels.
# Notice CHF levels are still not ordered.
x \%>\% ggplot(map) + geom_point()

# We can resolve guide for a chance to enrich the output with units.
# Notice CHF levels are now ordered.
x \%<>\% resolve
suppressWarnings( # because this complains for columns with no units
  x <- modify(x, title = paste0(label, '\n(', units, ')'))
)
x \%>\% ggplot(map) + geom_point()

# Or something fancier.
x \%<>\% modify(conc, title = 'conc_serum. (mg*L^-1.)')
x \%>\% ggplot(map) + geom_point()

# The y-axis title is deliberately given in spork syntax for elegant coercion:
library(spork)
x \%<>\% modify(conc, expression = as.expression(as_plotmath(as_spork(title))))
x \%>\% ggplot(map) + geom_point()
# Add a fancier label for Heart, and facet by a factor:
x \%<>\% modify(Heart, expression = as.expression(as_plotmath(as_spork('CHF^\\\\*'))))
x \%>\% ggplot(map) + geom_point() + facet_wrap(~Creatinine)

# ggready handles the units and plotmath implicitly for a 'standard' display:
x \%>\% ggready \%>\% ggplot(map) + geom_point() + facet_wrap(~Creatinine)

# Notice that instead of over-writing the label
# attribute, we are creating a stack of label
# substitutes (title, expression) so that
# label is still available as an argument
# if we want to try something else.  The
# print method by default looks for all of these.
# Precedence is expression, title, label, column name.
# Precedence can be controlled using
# options(decorated_ggplot_search = c(a, b, ...) ).

# Here we try a dataset with conditional labels and units.

file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- file \%>\% decorate \%>\% resolve
# Note that value has two elements for label and guide.
x \%>\% decorations(value)

# The print method defaults to the first, with warning.
map <- aes(x = time, y = value, color = event)
\donttest{
x \%>\% ggplot(map) + geom_point()
}

# If we subset appropriately, the relevant value is substituted.
x \%>\% filter(event == 'conc') \%>\% ggplot(map) + geom_point()

x \%>\% filter(event == 'conc') \%>\%
ggplot(aes(x = time, y = value, color = ApgarInd)) + geom_point()

x \%>\% filter(event == 'dose') \%>\%
ggplot(aes(x = time, y = value, color = Wt)) +
geom_point() +
scale_y_log10() +
scale_color_gradientn(colours = rainbow(4))
}
\seealso{
decorate resolve ggready

Other decorated_ggplot: 
\code{\link{ggplot_build.decorated_ggplot}()},
\code{\link{print.decorated_ggplot}()}

Other interface: 
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{modify.default}()},
\code{\link{promote.default}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{decorated_ggplot}
\concept{interface}
