% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical.R
\name{canonical.yamlet}
\alias{canonical.yamlet}
\title{Sort Yamlet}
\usage{
\method{canonical}{yamlet}(
  x,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  ...
)
}
\arguments{
\item{x}{yamlet}

\item{default_keys}{attribute names in preferred order}

\item{...}{ignored}
}
\value{
decorated
}
\description{
Enforces canonical attribute order for class 'yamlet'.
Set of default_keys will be augmented with all observed attribute names
and will be expanded or reduced as necessary for each
data item.
}
\examples{
library(magrittr)
x <- data.frame(x = 1, y = 1, z = factor('a'))
x \%<>\% decorate('
x: [ guide: mm, desc: this, label: foo ]
"y": [ guide: bar, desc: other ]
')

decorations(x)
decorations(canonical(x))
canonical(decorations(x))
write_yamlet(x)

}
\seealso{
Other canonical: 
\code{\link{canonical.decorated}()},
\code{\link{canonical}()}
}
\concept{canonical}
