% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate.R
\name{decorations.data.frame}
\alias{decorations.data.frame}
\title{Retrieve Decorations for Data Frame}
\usage{
\method{decorations}{data.frame}(
  x,
  ...,
  exclude_attr = getOption("yamlet_exclude_attr", c("class", "levels"))
)
}
\arguments{
\item{x}{data.frame}

\item{...}{optional unquoted column names to limit output (passed to \code{\link[dplyr]{select}})}

\item{exclude_attr}{attributes to remove from the result}
}
\value{
named list of class 'yamlet'
}
\description{
Retrieve the decorations of a data.frame; i.e., the metadata
used to decorate it. Returns a list with same names as the data.frame.
By default, 'class' and 'level' attributes are excluded from the result,
as you likely don't want to manipulate these independently.
}
\examples{
# prepare a decorated data.frame
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)

# retrieve the decorations
decorations(x, Subject, time, conc)
}
\seealso{
Other decorate: 
\code{\link{as_decorated}()},
\code{\link{as_decorated.default}()},
\code{\link{decorate}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorate_groups}()},
\code{\link{decorate_groups.data.frame}()},
\code{\link{decorations}()},
\code{\link{decorations_groups}()},
\code{\link{decorations_groups.data.frame}()},
\code{\link{group_by_decorations}()},
\code{\link{group_by_decorations.data.frame}()},
\code{\link{redecorate}()}
}
\concept{decorate}
