% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.x_pfi.R
\name{pnn.x_pfi}
\alias{pnn.x_pfi}
\title{Derive the permutation feature importance of a predictor used in the PNN}
\usage{
pnn.x_pfi(net, i, ntry = 1000, seed = 1)
}
\arguments{
\item{net}{A PNN object generated by pnn.fit()}

\item{i}{The ith predictor in the PNN}

\item{ntry}{The number of random permutations to try, 1e3 times by default}

\item{seed}{The seed value for the random permutation}
}
\value{
A vector with the variable name and the PFI value.
}
\description{
The function \code{pnn.x_pfi} derives the permutation feature importance (PFI) of a predictor used in the PNN, 
where the "importance" is deined by the increase in cross entropy after the predictor is randomly permutated.
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
pnn.x_pfi(pnet, 1)
}
\seealso{
\code{\link{pnn.x_imp}}
}
