% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{metric_vec_template}
\alias{metric_vec_template}
\title{Developer function for calling new metrics}
\usage{
metric_vec_template(
  metric_impl,
  truth,
  estimate,
  na_rm = TRUE,
  cls = "numeric",
  estimator = NULL,
  ...
)
}
\arguments{
\item{metric_impl}{The core implementation function of your custom metric.
This core implementation function is generally defined inside the vector
method of your metric function.}

\item{truth}{The realized vector of \code{truth}. This is either a factor
or a numeric.}

\item{estimate}{The realized \code{estimate} result. This is either a numeric
vector, a factor vector, or a numeric matrix (in the case of multiple
class probability columns) depending on your metric function.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA} values should be
stripped before the computation proceeds. \code{NA} values are removed
before getting to your core implementation function so you do not have to
worry about handling them yourself. If \code{na_rm=FALSE} and any \code{NA} values
exist, then \code{NA} is automatically returned.}

\item{cls}{A character vector of length 1 or 2 corresponding to the
class that \code{truth} and \code{estimate} should be, respectively. If \code{truth} and
\code{estimate} are of the same class, just supply a vector of length 1. If
they are different, supply a vector of length 2. For matrices, it is best
to supply \code{"numeric"} as the class to check here.}

\item{estimator}{The type of averaging to use. By this point, the averaging
type should be finalized, so this should be a character vector of length 1\.
By default, this character value is required to be one of: \code{"binary"},
\code{"macro"}, \code{"micro"}, or \code{"macro_weighted"}. If your metric allows more
or less averaging methods, override this with \code{averaging_override}.}

\item{...}{Extra arguments to your core metric function, \code{metric_impl}, can
technically be passed here, but generally the extra args are added through
R's scoping rules because the core metric function is created on the fly
when the vector method is called.}
}
\description{
\code{metric_vec_template()} is useful alongside \code{\link[=metric_summarizer]{metric_summarizer()}} for
implementing new custom metrics. \code{metric_summarizer()} calls the metric
function inside \code{dplyr::summarise()}. \code{metric_vec_template()} is a
generalized function that calls the core implementation of a metric function,
and includes a number of checks on the types, lengths, and argument inputs.
}
\details{
\code{metric_vec_template()} is called from the vector implementation of your
metric. Also defined inside your vector implementation is a separate
function performing the core implementation of the metric function. This
core function is passed along to \code{metric_vec_template()} as \code{metric_impl}.
}
\seealso{
\code{\link[=metric_summarizer]{metric_summarizer()}} \code{\link[=finalize_estimator]{finalize_estimator()}} \code{\link[=dots_to_estimate]{dots_to_estimate()}}
}
