% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_rticles.R
\name{yml_rticles_opts}
\alias{yml_rticles_opts}
\alias{rticles_author}
\alias{rticles_address}
\alias{rticles_corr_author}
\title{Set YAML related to rticles output formats}
\usage{
yml_rticles_opts(
  .yml,
  title = yml_blank(),
  runninghead = yml_blank(),
  author = yml_blank(),
  authormark = yml_blank(),
  address = yml_blank(),
  corrauth = yml_blank(),
  corres = yml_blank(),
  email = yml_blank(),
  abstract = yml_blank(),
  received = yml_blank(),
  revised = yml_blank(),
  accepted = yml_blank(),
  keywords = yml_blank(),
  bibliography = yml_blank(),
  longtable = yml_blank(),
  classoption = yml_blank(),
  header_includes = yml_blank(),
  include_after = yml_blank(),
  ...
)

rticles_author(name = yml_blank(), num = yml_blank())

rticles_address(name = yml_blank(), org = yml_blank())

rticles_corr_author(
  name = yml_blank(),
  author = yml_blank(),
  address = yml_blank()
)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{title}{Title of the manuscript}

\item{runninghead}{A character vector, a short author list for the header
(sage_article)}

\item{author}{A list of authors, containing \code{name} and \code{num} fields
(sage_article, sim_article). Use \code{rticles_author()} or a list to specify.}

\item{authormark}{A character vector, the short author list for the header
(sim_article)}

\item{address}{list containing \code{num} and \code{org} for defining author
affiliations (sage_article, sim_article). Use \code{rticles_address()} or a list
to specify.}

\item{corrauth}{corresponding author \code{name} and \code{address} (sage_article). Use
\code{rticles_corr_author()} or a list to specify.}

\item{corres}{\code{author} and \code{address} for correspondence (sim_article). Use
\code{rticles_corr_author()} or a list to specify.}

\item{email}{The email of the correspondence author (sage_article)}

\item{abstract}{The abstract, limited to 200 words (sage_article), 250 words
(sim_article)}

\item{received, revised, accepted}{The dates of submission, revision, and
acceptance of the manuscript (sim_article)}

\item{keywords}{The keywords for the article (sage_article), up to 6 keywords
(sim_article)}

\item{bibliography}{BibTeX \code{.bib} file name  (sage_article, sim_article)}

\item{longtable}{Logical. Include the longtable package? Used by default from
pandoc to convert markdown to LaTeX code (sim_article)}

\item{classoption}{a character vector of \code{classoption} options for the
\code{sagej} class (sage_article)}

\item{header_includes}{additional LaTeX code to include in the header, before
the \verb{\\\\begin\\\{document\\\}} statement (sage_article, sim_article). Note that
the actual YAML field is \code{header-includes}}

\item{include_after}{additional LaTeX code to include before the
\verb{\\\\end\\\{document\\\}} statement (sage_article, sim_article). Note that the
actual YAML field is \code{include-after}.}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}

\item{name}{The author's name}

\item{num}{The author's number or address number}

\item{org}{The author's organization}
}
\value{
a \code{yml} object
}
\description{
The rticles package include numerous output formats specific to academic
journals. All of these can take YAML similar to \code{pdf_document()}.
Additionally, two templates include custom YAML, \code{rticles::sage_article()}
and \code{rticles::sim_article()}. See the help pages for these functions for more
details and the sources of the LaTeX templates used for each.
}
\examples{

yml() \%>\%
  yml_rticles_opts(received = "09-12-2014")

}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
