% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{border}
\alias{border}
\title{Border color}
\usage{
border(tag, color = NULL, sides = "all", round = NULL)
}
\arguments{
\item{tag}{A tag element.}

\item{color}{One of "\code{red}", "\code{purple}", "\code{indigo}", "\code{blue}", "\code{cyan}", "\code{teal}", "\code{green}", "\code{yellow}", "\code{amber}", "\code{orange}", "\code{grey}", "\code{black}" or "\code{white}" specifying the border color of the tag element, defaults to \code{NULL}}

\item{sides}{One or more of \code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"} or
\code{"all"} or \code{"none"} specifying which sides to add a border to, defaults to
\code{"all"}.}

\item{round}{One or more of \code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"},
\code{"circle"}, \code{"all"}, or \code{"none"} specifying how to round the border(s) of a
tag element, defaults to \code{NULL}, in which case the argument is ignored.}
}
\description{
Use \code{border()} to add or modify tag element borders.
}
\examples{

### Change border color

div(
  div() \%>\%
    height(3) \%>\%
    width(3) \%>\%
    border("green"),
  div() \%>\%
    height(3) \%>\%
    width(3) \%>\%
    border(
      color = "blue",
      sides = c("left", "right")
    )
)

### Round sides

sides <- c("top", "right", "bottom", "left", "circle", "all")

div(
  lapply(
    sides,
    border,
    tag = div() \%>\%
      height(3) \%>\%
      width(3),
    color = "black"
  )
) \%>\%
  display("flex") \%>\%
  flex(wrap = TRUE)

}
\seealso{
Other design utilities: 
\code{\link{active}()},
\code{\link{affix}()},
\code{\link{background}()},
\code{\link{display}()},
\code{\link{float}()},
\code{\link{font}()},
\code{\link{height}()},
\code{\link{padding}()},
\code{\link{scroll}()},
\code{\link{shadow}()},
\code{\link{width}()}
}
\concept{design utilities}
