% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal.R
\name{modal}
\alias{modal}
\alias{showModal}
\alias{closeModal}
\title{Modal dialogs}
\usage{
modal(
  id,
  ...,
  header = NULL,
  footer = NULL,
  center = FALSE,
  size = "md",
  fade = TRUE
)

showModal(modal, session = getDefaultReactiveDomain())

closeModal(id = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the modal, when closed
\code{input[[id]]} is set to \code{TRUE}.}

\item{...}{Unnamed values passed as tag elements to the body of the modal.
or named values passed as HTML attributes to the body element of the
modal.}

\item{header}{A character string or tag element specifying the header of the
modal.}

\item{footer}{A character string or tag element specifying the footer of the
modal.}

\item{center}{One of \code{TRUE} or \code{FALSE} specifying whether the modal is
vertically centered on the page, defaults to \code{FALSE}.}

\item{size}{One of \code{"sm"} (small), \code{"md"} (medium), \code{"lg"} (large), or \code{"xl"}
(extra large) specifying the relative width of the modal, defaults to
\code{"md"}.}

\item{fade}{One of \code{TRUE} or \code{FALSE} specifying if the modal fades in when
shown and fades out when closed, defaults to \code{TRUE}.}

\item{modal}{A modal tag element created using \code{modal()}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
Modals are a flexible alert window, which disable interaction with the page
behind them. Modals may include inputs, buttons, or simply text. Each modal
may be assigned an \code{id}. By default \code{hideModal()} will hide all modals, but
you may instead specify a modal's \code{id} in which case only that modal is
closed. Additionally, when \code{id} is not \code{NULL} observers and reactives may
watch for the modal's close event.
}
\section{Example application}{
\if{html}{\out{<div class="R">}}\preformatted{ui <- container(
  buttonInput(
    id = "open",
    "Open modal",
    icon("plus")
  )
)

server <- function(input, output) \{
  modal1 <- modal(
    title = "A simple modal",
    p(
      "Cras mattis consectetur purus sit amet fermentum.",
      "Cras justo odio, dapibus ac facilisis in, egestas",
      "eget quam. Morbi leo risus, porta ac consectetur",
      "ac, vestibulum at eros."
    )
  )

  observeEvent(input$open, ignoreInit = TRUE, \{
    showModal(modal1)
  \})
\}

shinyApp(ui, server)
}\if{html}{\out{</div>}}
}

\examples{

### Simple modal

modal(
  id = "simple",
  header = h5("Title"),
  p("Cras placerat accumsan nulla.")
)

### Modal with container body

modal(
  id = "more_complex",
  size = "lg",
  header = h5("More complex"),
  container(
    columns(
      column("Cras placerat accumsan nulla."),
      column("Curabitur lacinia pulvinar nibh."),
      column(
        "Aliquam posuere.",
        "Praesent fermentum tempor tellus."
      )
    )
  )
)

}
\seealso{
Other components: 
\code{\link{alert}()},
\code{\link{badge}()},
\code{\link{blockquote}()},
\code{\link{card}()},
\code{\link{collapsePane}()},
\code{\link{d1}()},
\code{\link{dropdown}()},
\code{\link{img}()},
\code{\link{jumbotron}()},
\code{\link{navContent}()},
\code{\link{popover}()},
\code{\link{pre}()},
\code{\link{toast}()}
}
\concept{components}
