% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlersWicketsOppnAllMatches.R
\name{teamBowlersWicketsOppnAllMatches}
\alias{teamBowlersWicketsOppnAllMatches}
\title{Team bowlers  wickets against an opposition in all matches}
\usage{
teamBowlersWicketsOppnAllMatches(matches,main,opposition,plot=TRUE,top=20)
}
\arguments{
\item{matches}{The data frame of all matches between a team the opposition. This dataframe can be obtained with
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")}

\item{main}{The team for which the performance is required}

\item{opposition}{The opposing team}

\item{plot}{If plot=TRUE then a plot is displayed else a dataframe is returned}

\item{top}{The number of top bowlers to be included in the result}
}
\value{
None or dataframe
The return depends on the value of the plot
}
\description{
This function computes performance of bowlers of a team and the wickets taken against an
opposition in all matches against the opposition
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India and Australia
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")

#Display top 20
teamBowlersWicketsOppnAllMatches(matches,"India","Australia")
#Display and plot top 10
teamBowlersWicketsOppnAllMatches(matches,"Australia","India",top=10)

#Do not plot but return as dataframe
teamBowlersWicketsOppnAllMatches(matches,"India","Australia",plot=FALSE)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesRept}}\cr
\code{\link{teamBowlersWicketRunsOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
