% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowlerMovingAverage.R
\name{bowlerMovingAverage}
\alias{bowlerMovingAverage}
\title{Bowler's moving average of wickets}
\usage{
bowlerMovingAverage(df, name,staticIntv1=1)
}
\arguments{
\item{df}{Data frame}

\item{name}{Name of bowler}

\item{staticIntv1}{Static or interactive -staticIntv1 =1 (static plot) &  staticIntv1 =2 (interactive  plot)}
}
\value{
None
}
\description{
This function computes and plots the wickets taken by the bowler over career. A loess
regression fit plots the moving average of wickets taken by bowler
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get the data frame for RA Jadeja
jadeja <- getBowlerWicketDetails(team="India",name="Jadeja",dir=pathToFile)
bowlerMeanRunsConceded(jadeja,"RA Jadeja")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{bowlerMeanEconomyRate}}\cr
\code{\link{bowlerWicketPlot}}\cr
\code{\link{bowlerWicketsVenue}}\cr
\code{\link{bowlerMeanRunsConceded}}\cr
}
\author{
Tinniam V Ganesh
}
